% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotMIRAScores}
\alias{plotMIRAScores}
\title{Plot MIRA scores and compare different conditions}
\usage{
plotMIRAScores(scoreDT, featID = unique(scoreDT[, featureID]),
  colBlindOption = FALSE)
}
\arguments{
\item{scoreDT}{A datatable with the following columns: 
score, featureID (names of region sets), ideally include 'sampleType'.}

\item{featID}{Region set name/names in a single string or vector of strings.}

\item{colBlindOption}{If TRUE, function will plot with a color blind
friendly palette which could be helpful when plotting multiple colors.}
}
\value{
a plot of class "gg"/"ggplot" that shows MIRA scores 
with geom_boxplot and geom_jitter (or geom_violin instead
of boxplot if no sampleType column is given).
}
\description{
Splits up samples by sample type. Displays each region set
in a different subplot.
If you only want to plot certain region sets,
subset with the `featID` parameter.
}
\details{
Due to the limited number
of colors in the palette, a warning will be issued if 
there are too many (more than 9) region sets ('featureID's).
}
\examples{
data(bigBinDT2)
exScores <- calcMIRAScore(bigBinDT2)
# adding annotation
sampleType <- rep(c("Ewing", "Muscle-related"), each = 24)
exScores <- cbind(exScores, sampleType)
exScorePlot <- plotMIRAScores(exScores)         
}
