% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{bsseqToDataTable}
\alias{bsseqToDataTable}
\title{Convert a BSseq object to data.table format for MIRA.}
\usage{
bsseqToDataTable(BSseqObj)
}
\arguments{
\item{BSseqObj}{An object of class BSseq, can have smoothed or raw
methylation data.}
}
\value{
MIRAFormatBSDTList A list of data.tables containing
the methylation data. One data.table per sample with the column
names: 'chr', 'start' (methylation coordinate), 'methylCount' (number of
methylated reads), 'coverage' (total number of reads), and 
'methylProp' (proportion of methylated reads). The order of the
list is the order of samples in the columns of the BSseq object.
If sample names are in the BSseq object, then a named list
will be returned.
}
\description{
Converts a BSseq object to a list of data.tables with one data.table
per sample. A wrapper of the SummarizedExperimentToDataTable function.
}
\examples{
data("exampleBSseqObj")
MIRAFormatBSDTList <- bsseqToDataTable(exampleBSseqObj)
}
