#' A data.table containing DNA methylation data.
#' 
#' This object contains reduced
#' representation bisulfite sequencing data from the
#' GM06990 B-lymphoblastoid cell line that was generated by the ENCODE
#' project (GEO accession GSE27584, sample GSM980583). Has columns for
#' position (chr, start), number methylated reads, and number of reads total.
#' The sample name is Gm06990_1.
#' Only a subset of the full data is used in this object and the 
#' data was switched from hg19 to hg38.
#'
#'
#' @docType data
#' @keywords datasets
#' @name exampleBSDT
#' @usage data(exampleBSDT)
#' @format A data.table, data.frame object
NULL

#' A Granges object with Nrf1-binding regions.
#' 
#' A GRanges object with a ranges corresponding to Nrf1 Chip-seq peaks
#' in the GM12878 B-lymphoblastoid cell line (GEO accession GSE31477, 
#' sample GSM935309). Only a subset of the ranges are used in 
#' this object and the regions were switched from hg19 to hg38.
#'
#'
#' @docType data
#' @keywords datasets
#' @name exampleRegionSet
#' @usage data(exampleRegionSet)
#' @format A GRanges object
NULL

#' A data.table with annotation for a bisulfite sample.
#' 
#' Has columns for name and sample type. 
#'
#'
#' @docType data
#' @keywords datasets
#' @name exampleAnnoDT1
#' @usage data(exampleAnnoDT1)
#' @format A data.table, data.frame object
NULL

#' A data.table with artificial binned methylation data
#'
#' Artificial data for two samples/conditions.
#'
#' @docType data
#' @keywords datasets
#' @name exampleBins
#' @usage data(exampleBins)
#' @format A data.table, data.frame object
NULL

#' DNA methylation data for the "Applying MIRA to a Biological Question"
#' vignette (1st part).
#' 
#' A data.table with binned methylation data for the first part of
#' the "Applying MIRA to a Biological Question" vignette. 
#' Has data for 3 Ewing samples and 3 muscle-related 
#' samples (human skeletal myoblasts and other related
#' samples). It is the product of `aggregateMethyl`.
#'
#'
#' @docType data
#' @keywords datasets
#' @name bigBinDT1
#' @usage data(bigBinDT1)
#' @format A data.table, data.frame object
NULL

#' DNA methylation data for the "Applying MIRA to a Biological Question" 
#' vignette (2nd part).
#' 
#' A data.table with binned methylation data for the second part
#' of the "Applying MIRA to a Biological Question" vignette. 
#' Has data for 12 Ewing samples and 12 muscle-related samples 
#' (human skeletal myoblasts and other related
#' samples). It is the product of `aggregateMethyl`.
#'
#'
#' @docType data
#' @keywords datasets
#' @name bigBinDT2
#' @usage data(bigBinDT2)
#' @format A data.table, data.frame object
NULL

#' Annotation data for the "Applying MIRA to a 
#' Biological Question" vignette. 
#' 
#' A data.table with annotation data (sampleName
#' and sampleType columns) for 24 Ewing samples and 24 muscle-related
#' samples (human skeletal myoblasts and other related samples).
#'
#'
#' @docType data
#' @keywords datasets
#' @name exampleAnnoDT2
#' @usage data(exampleAnnoDT2)
#' @format A data.table, data.frame object
NULL

#' A small BSseq object.
#' 
#' A BSseq object which has the top 20 rows of the BSseq object "BS.chr22"
#' which was included as built-in data in the bsseq package
#' 
#' 
#' @docType data
#' @keywords datasets
#' @name exampleBSseqObj
#' @usage data(exampleBSseqObj)
#' @format A BSseq object
NULL