% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/searchAnalysis.R
\name{searchAnalysis}
\alias{searchAnalysis}
\alias{searchAnalysis,MgnifyClient-method}
\title{Look up analysis accession IDs for one or more study or sample accessions}
\usage{
searchAnalysis(x, ...)

\S4method{searchAnalysis}{MgnifyClient}(x, type, accession, ...)
}
\arguments{
\item{x}{A \code{MgnifyClient} object.}

\item{...}{Optional arguments; not currently used.}

\item{type}{A single character value specifying a type of
accession IDs specified by \code{accession}. Must be "studies" or "samples".}

\item{accession}{A single character value or a vector of character values
specifying study or sample accession IDs that are used to retrieve analyses
IDs.}
}
\value{
Vector of analysis accession IDs.
}
\description{
Look up analysis accession IDs for one or more study or sample accessions
}
\details{
Retrieve analysis accession IDs associated with the supplied study or
sample accession.  In MGnify, an analysis accession refers to a certain
pipeline analysis, such as specific 16S rRNA or shotgun metagenomic mapping.
Studies can include multiple samples, and each sample can undergo multiple
analyses using these pipelines. Each analysis is identified by a unique
accession ID, allowing precise tracking and retrieval of analysis results
within the MGnify database.
}
\examples{
# Create a client object
mg <- MgnifyClient(useCache = FALSE)

# Retrieve analysis ids from study MGYS00005058
result <- searchAnalysis(mg, "studies", c("MGYS00005058"))

\dontrun{
# Retrieve all analysis ids from samples
result <- searchAnalysis(
    mg, "samples", c("SRS4392730", "SRS4392743"))
}

}
