% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/doQuery.R
\name{doQuery}
\alias{doQuery}
\alias{doQuery,MgnifyClient-method}
\title{Search MGnify database for studies, samples, runs, analyses, biomes,
assemblies, and genomes.}
\usage{
doQuery(x, ...)

\S4method{doQuery}{MgnifyClient}(
  x,
  type = "studies",
  accession = NULL,
  as.df = TRUE,
  max.hits = 200,
  ...
)
}
\arguments{
\item{x}{A \code{MgnifyClient} object.}

\item{...}{Remaining parameter key/value pairs may be supplied to filter
the returned values. Available options differ between \code{types}.
See discussion Details section for details.}

\item{type}{A single character value specifying the type of objects to
query. Must be one of the following options: \code{studies}, \code{samples},
\code{runs}, \code{analyses}, \code{biomes}, \code{assemblies},
\code{super-studies}, \code{experiment-types}, \code{pipelines},
\code{pipeline-tools}, \code{publications}, \code{genomes},
\code{genome-search}, \code{genome-search/gather}, \code{genome-catalogues},
\code{genomeset}, \code{cogs}, \code{kegg-modules}, \code{kegg-classes},
\code{antismash-geneclusters}, \code{annotations/go-terms},
\code{annotations/interpro-identifiers}, \code{annotations/kegg-modules},
\code{annotations/pfam-entries}, \code{annotations/kegg-orthologs},
\code{annotations/genome-properties},
\code{annotations/antismash-gene-clusters}, \code{annotations/organisms}, or
\code{mydata}.
(By default: \code{type = "studies"})}

\item{accession}{A single character value or a vector of character values
specifying MGnify accession identifiers (of type \code{type}) or NULL. When
NULL, all results defined by other parameters are retrieved.
(By default: \code{accession = NULL})}

\item{as.df}{A single boolean value specifying whether to return the
results as a data.frame or leave as a nested list. In most cases,
\code{as.df = TRUE} will make the most sense.
(By default: \code{as.df = TRUE})}

\item{max.hits}{A single integer value specifying the maximum number of
results to return or FALSE. The actual number of results will actually be
higher than \code{max.hits}, as clipping only occurs on pagination page
boundaries. To disable the limit, set \code{max.hits = NULL}.
(By default: \code{max.hits = 200})}
}
\value{
A nested list or data.frame containing the results of the query.
}
\description{
Search MGnify database for studies, samples, runs, analyses, biomes,
assemblies, and genomes.
}
\details{
\code{doQuery} is a flexible query function, harnessing the "full"
power of the JSONAPI MGnify search filters. Search results may be filtered
by metadata value, associated study/sample/analyse etc.

See \href{https://www.ebi.ac.uk/metagenomics/api/v1/}{Api browser} for
information on MGnify database filters.
You can find help on customizing queries from
\href{https://emg-docs.readthedocs.io/en/latest/api.html#customising-queries}{here}.

For example the following filters are available:
\itemize{
    \item{\strong{studies}: accession, biome_name, lineage, centre_name,
    include}
    \item{\strong{samples}: accession, experiment_type, biome_name,
    lineage, geo_loc_name, latitude_gte, latitude_lte,
    longitude_gte, longitude_lte, species, instrument_model,
    instrument_platform, metadata_key, metadata_value_gte,
    metadata_value_lte, metadata_value, environment_material,
    environment_feature, study_accession, include}
    \item{\strong{runs}: accession, experiment_type, biome_name, lineage,
    species, instrument_platform, instrument_model, metdata_key,
    metadata_value_gte, metadata_value_lte, metadata_value, sample_accession,
    study_accession, include}
    \item{\strong{analyses}: biome_name, lineage, experiment_type, species,
    sample_accession, pipeline_version}
    \item{\strong{biomes}: depth_gte, depth_lte}
    \item{\strong{assemblies}: depth_gte, depth_lte}
 }
Unfortunately it appears that in some cases, some of these filters don't work
as expected, so it is important to check the results returned match up with
what's expected. Even more unfortunately if there's an error in the parameter
specification, the query will run as if no filter parameters were present
at all. Thus the result will appear superficially correct but will infact
correspond to something completely different. This behaviour will hopefully
be fixed in future incarnations of the MGnifyR or JSONAPI, but for now users
should double check returned values.

It is currently not possible to combine queries of the same type in a single
call (for example to search for samples \emph{between} latitude). However,
it is possible to run multiple queries and combine the results using set
operations in R to get the desired behaviour.
}
\examples{
mg <- MgnifyClient(useCache = FALSE)

# Get a list of studies from the Agricultural Wastewater :
agwaste_studies <- doQuery(
    mg, "studies", biome_name="Agricultural wastewater"
    )

\dontrun{
# Get all samples from a particular study
samps <- doQuery(mg, "samples", accession="MGYS00004521")

# Search polar samples
samps_np <- doQuery(mg, "samples", latitude_gte=66, max.hits=10)
samps_sp <- doQuery(mg, "samples", latitude_lte=-66, max.hits=10)

# Search studies that have studied drinking water
tbl <- doQuery(
    mg,
    type = "studies",
    biome_name = "root:Environmental:Aquatic:Freshwater:Drinking water",
    max.hits = 10)
}

}
