% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleaning.R
\name{clean_beta}
\alias{clean_beta}
\title{Clean beta-matrix.}
\usage{
clean_beta(SE = NULL, version = "MEAT2.0")
}
\arguments{
\item{SE}{A \code{\link[SummarizedExperiment]{SummarizedExperiment-class}} object.
The "assays" component of \code{SE} should contain a beta-matrix of
DNA methylation beta-values called "beta", with samples in columns
and CpGs in rows.
\code{SE} may optionally contain annotation information on the CpGs
stored in "rowData" and sample phenotypes stored in "colData".}

\item{version}{A character specifying which version of the epigenetic clock
you would like to use. Dy default, \code{version} is set to "MEAT2.0" for the
second version of the epigenetic clock. If you would like to use the original
version, set \code{version} to "MEAT".}
}
\value{
A clean version of the input \code{SE} reduced to the right CpGs,
with missing values imputed, and without 0 or 1 values.
}
\description{
\code{clean_beta} reduces the beta-matrix stored in the input
SummarizedExperiment object \code{SE} to the right CpGs, imputes missing
values if any, and replaces 0 and 1 with min and max values.
}
\details{
\code{clean_beta} will transform the the beta-matrix stored in \code{SE} by:
\enumerate{
\item reducing it to the CpGs used to calibrate DNA methylation profiles
to the gold standard. By default, \code{clean_beta} will reduce your beta-matrix
to the 18,747 CpGs used in the updated version of MEAT (MEAT 2.0).
If you would like to use the original version of MEAT, \code{clean_beta}
will reduce your data to the 19,401 CpGs that are in common between the 12
datasets from the original publication.
\item checking whether it contains missing values, and impute them with
\code{\link[impute]{impute.knn}},
\item check whether it contains 0 and 1 values, and if any, change them to the
minimum non-0 and maximum non-1 values in the beta-matrix.
}
}
\examples{
# Load matrix of beta-values of two individuals from dataset GSE121961
data("GSE121961", envir = environment())
# Load phenotypes of the two individuals from dataset GSE121961
data("GSE121961_pheno", envir = environment())

# Create a SummarizedExperiment object to coordinate phenotypes and
# methylation into one object.
library(SummarizedExperiment)
GSE121961_SE <- SummarizedExperiment(assays=list(beta=GSE121961),
colData=GSE121961_pheno)

# Run clean_beta() to clean the beta-matrix
GSE121961_SE_clean <- clean_beta(SE = GSE121961_SE, version = "MEAT2.0")
}
\seealso{
\code{\link[impute]{impute.knn}} for imputation of missing values,
and \code{\link[SummarizedExperiment]{SummarizedExperiment-class}} for more
details on how to create and manipulate SummarizedExperiment objects.


}
