% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runRDA.R
\name{runRDA}
\alias{runRDA}
\title{Calculate RDA for a set}
\usage{
runRDA(
  set,
  model,
  num_vars = ncol(model),
  range,
  betas = FALSE,
  resultSet = TRUE,
  num_permutations = 10000,
  ...
)
}
\arguments{
\item{set}{\code{MethylationSet}, \code{ExpressionSet} or \code{matrix}}

\item{model}{Model matrix or formula to get model matrix from \code{set}.}

\item{num_vars}{Numeric with the number of variables in the matrix for which the
analysis will be performed. Compulsory if equation is not null.}

\item{range}{\code{GenomicRanges} with the region used for RDA}

\item{betas}{If \code{set} is a \code{GenomicRatioSet}, should beta values be
used? (Default: TRUE)}

\item{resultSet}{Should results be encapsulated in a \code{resultSet}? (Default: TRUE)}

\item{num_permutations}{Numeric with the number of permutations run to compute 
the p-value. (Default: 1e4)}

\item{...}{Further arguments passed to \code{rda}.}
}
\value{
Object of class \code{rda} or \code{resultSet}
}
\description{
Perform RDA calculation for a \code{AnalysisRegionResults}. Feature values will
be considered the matrix X and phenotypes the matrix Y. Adjusting for covariates 
is done using a model matrix passed in covarsmodel.
}
\examples{
if (require(minfiData)){
set <- ratioConvert(mapToGenome(MsetEx[1:10,]))
model <- model.matrix(~set$age)
rda <- runRDA(set, model)
rda
}
}
\seealso{
\code{\link[vegan]{rda}}
}
