% Generated by roxygen2 (4.0.1): do not edit by hand
\name{estimateMAF1s}
\alias{estimateMAF1s}
\title{Function that given observed count data returns a maximum likelihood estimate of the underlying haplotype frequency. Both situations where the haplotype are known and unknown are handled. In the latter case, likelihood is further maximized over all possible assignments of alleles to haplotypes.}
\usage{
estimateMAF1s(lociAllele1Counts, lociTotalCounts, lociAllele1NoASEProbs,
  lociRhos, isPhased = FALSE, checkArgs = FALSE)
}
\arguments{
\item{lociAllele1Counts}{counts of allele1-supporting reads at individual loci. Must be a vector of non-negative integers.}

\item{lociTotalCounts}{total read counts of at individual loci. Must be a vector of positive integers.}

\item{lociAllele1NoASEProbs}{probabilities of observing allele1-supporting reads at individual loci under conditions of no ASE (e.g., vector with all entries set to 0.5, if there is no pre-existing allelic bias at any locus). Must be a vector with entries >0 and <1.}

\item{lociRhos}{dispersion parameters of beta distribution at individual loci (set to 0 if the read count-generating distribution at the locus is binomial). Must be a numeric vector with entries >=0 and <1.}

\item{isPhased}{single boolean specifying whether the phasing has already been performed, in which case the lociAllele1Counts represent the same haplotype. If FALSE (DEFAULT), likelihood is further maximized over all possible assignments of alleles to haplotypes.}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}
}
\value{
a list with two elements: MAF (MLE of major allele frequency) and allele1IsMajor (whether allele1 is assigned to haplotype corresponding to maximum likleihood MAF).
}
\description{
Function that given observed count data returns a maximum likelihood estimate of the underlying haplotype frequency. Both situations where the haplotype are known and unknown are handled. In the latter case, likelihood is further maximized over all possible assignments of alleles to haplotypes.
}
\details{
Given observed read counts supporting allele1 at a collection of loci, the total read counts at those loci, the probablities of observing allele1-supporting reads under conditions of no ASE and the dispersion parameters, this function returns a maximum likelihood estimate of the major haplotype frequency as well as corresponding assignment of alleles to haplotypes.
}
\examples{
MBASED:::estimateMAF1s(lociAllele1Counts=c(5, 24), lociTotalCounts=c(15, 36), lociAllele1NoASEProbs=c(0.5, 0.5), lociRhos=c(0,0), isPhased=TRUE)
MBASED:::estimateMAF1s(lociAllele1Counts=c(5, 24), lociTotalCounts=c(15, 36), lociAllele1NoASEProbs=c(0.5, 0.5), lociRhos=c(0,0), isPhased=FALSE)
}

