% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlmHooks.R
\name{collectResiduals}
\alias{collectResiduals}
\alias{discrete_residuals_hook}
\alias{continuous_residuals_hook}
\alias{combined_residuals_hook}
\alias{deviance_residuals_hook}
\alias{fitted_phat}
\alias{partialScore}
\title{Residual hooks and collection methods}
\usage{
collectResiduals(x, sca, newLayerName = "Residuals")

discrete_residuals_hook(x)

continuous_residuals_hook(x)

combined_residuals_hook(x)

deviance_residuals_hook(x)

fitted_phat(x)

partialScore(x, effectRegex)
}
\arguments{
\item{x}{\code{ZlmFit}-class}

\item{sca}{\code{SingleCellAssay} object to which the residuals should be added}

\item{newLayerName}{\code{character} name of the assay layer}

\item{effectRegex}{a regular expression naming columns of the design corresponding to \eqn{Z_0}.
Generally these should be the treatment effects of interest.}
}
\value{
copy of \code{sca} with new layer
}
\description{
After each gene is fit, a hook function can optionally be run and the output saved.
This allows extended computations to be done using the fitted model, without keeping it in memory.
Here this is used to calculate various residuals, though in some cases they can be done using only the information contained in the \code{ZlmFit}-class.
}
\section{Functions}{
\itemize{
\item \code{discrete_residuals_hook()}: Hook to get the discrete residuals, ie, difference between expected probability of expression and observed

\item \code{continuous_residuals_hook()}: Hook to get the continuous residuals, ie, residuals for conditionally positive observations.  If an observation is zero, it's residual is defined to be zero as well.

\item \code{combined_residuals_hook()}: Hook to get the combined residuals, ie, Y-E(U)*E(V)

\item \code{deviance_residuals_hook()}: Standardized deviance residuals hook. Computes the sum of the standardized deviance residuals for the discrete and continuous models (scaled to have unit variance).  If the observation is zero then only the discrete component is used.

\item \code{fitted_phat()}: Hook to return p_hat, the predicted probability of expression.

\item \code{partialScore()}: Compute \eqn{Y_i-E(V_i|X_i, Z_0)E(U|X_i, Z_0)}, where \eqn{Z_0} is a  treatment effect (being left in) and \eqn{X_i} is a nuisance effect (being regressed out).

}}
\section{Total residual types}{

Each component of the model contributes several flavors of residual, which can be combined in various fashions.
The discrete residual can be on the response scale (thus subtracting the predicted probability of expression from the 0/1 expression value).
Or it can be a deviance residual, revealing something about the log-likelihood.
}

\section{Partial residuals}{

It's also possible to consider partial residuals, in which the contribution of a particular covariate is added back into the model.
}

\examples{
data(vbetaFA)
svbeta <- subset(vbetaFA, ncells==1)
svbeta <- svbeta[freq(svbeta)>.4,]
window <- function(x1) lapply(assays(x1), function(x2) x2[1:3, 1:6])
#total residuals of the response
z1 <- zlm(~ Stim.Condition, svbeta, hook=discrete_residuals_hook)
window(collectResiduals(z1, svbeta))
z2 <- zlm(~ Stim.Condition, svbeta, hook=continuous_residuals_hook)
window(collectResiduals(z2, svbeta))
z3 <- zlm(~ Stim.Condition, svbeta, hook=combined_residuals_hook)
window(collectResiduals(z3, svbeta))
#partial residuals
colData(svbeta)$ngeneson <- colMeans(assay(svbeta)>0)
z5 <- zlm(~ Stim.Condition + ngeneson, svbeta)
partialScore(z5, 'Stim.Condition')
}
\seealso{
zlm
}
