##############################
## Base
###############################


##' Accessor for wellKey
##'
##' This returns the wellKey, which is a unique identifier generated by \code{idvars} in the \code{mapping}
##' @param sc An object with a \code{wellKey}
##' @return \code{integer} giving the unique id generated
##' @aliases getwellKey,SingleCellAssay-method
##' @examples
##' data(vbetaFA)
##' getwellKey(vbetaFA)
##' colData(vbetaFA)$wellKey
##' @export
setGeneric('getwellKey', function(sc) standardGeneric('getwellKey'))




##' @import BiocGenerics
##' @importMethodsFrom BiocGenerics subset
NULL

###############################
## LmWrapper
###############################
##' fit a zero-inflated regression
##'
##' Given a design and formula, fit the zero inflated regression, storing the fits in slots
##' \code{fitC} and \code{fitD}
##' @param object inheriting from \code{LMlike}
##' @param response a vector, same length as the design, or if missing then use the current response
##' @param ... currently ignored
##' @return LMlike or subclass
##' @aliases fit,GLMlike,missing-method
##' @aliases fit,BayesGLMlike,missing-method
setGeneric('fit', function(object, response, ...) standardGeneric('fit'))

##' Return coefficient standard errors
##'
##' Given a fitted model, return the standard errors of the coefficient
##' @param object a model implementing \code{vcov}
##' @param ... passed to methods
##' @seealso ZlmFit-class
##' @return vector or matrix
##' 
##' @examples
##' #see ZlmFit-class for examples
##' example('ZlmFit-class')
setGeneric('se.coef', function(object, ...) standardGeneric('se.coef'))


##' Run a likelihood-ratio test
##'
##' Compares the change in likelihood between the current model and one subject to contrasts tested in \code{hypothesis}.
##' \code{hypothesis} can be one of a \code{character} giving complete factors or terms to be dropped from the model, \code{CoefficientHypothesis} giving names of  coefficients to be dropped, \code{Hypothesis} giving contrasts using the symbolically, or a contrast \code{matrix}, with one row for each coefficient in the full model, and one column for each contrast being tested.
##' @param object LMlike or subclass
##' @param hypothesis the hypothesis to be tested.  See details.
##' @param ... optional arguments, passed to fitting functions
##' @return array giving test statistics
##' @export
##' @seealso fit
##' @seealso waldTest
##' @seealso Hypothesis
##' @seealso CoefficientHypothesis
##' 
##' @examples
##' #see ZlmFit-class for examples
##' example('ZlmFit-class')
setGeneric('lrTest', function(object, hypothesis, ...) standardGeneric('lrTest'))

##' Run a Wald test
##'
##' Run a Wald tests on discrete and continuous components
##' \code{hypothesis} can be one of a \code{character} giving complete factors or terms to be dropped from the model, \code{CoefficientHypothesis} giving names of  coefficients to be dropped, \code{Hypothesis} giving contrasts using the symbolically, or a contrast \code{matrix}, with one row for each coefficient in the full model, and one column for each contrast being tested.
##' @param object LMlike or subclass
##' @param hypothesis the hypothesis to be tested.  See details.
##' @return array giving test statistics
##' @export
##' @seealso fit
##' @seealso lrTest
##' @seealso lht
##' @examples
##' #see ZlmFit-class for examples
##' example('ZlmFit-class')
setGeneric('waldTest', function(object, hypothesis) standardGeneric('waldTest'))

##' Degrees of freedom of Zero inflated model
##'
##' @param object LMlike or subclass
##' @return vector giving the model degrees of freedom for continuous and discrete
##' @aliases dof,GLMlike-method
##' @aliases dof,LMERlike-method
setGeneric('dof', function(object) standardGeneric('dof'))


##' Model matrix accessor
##'
##' @param object LMlike or subclass
##' @return model.matrix if present
setGeneric('model.matrix', function(object) standardGeneric('model.matrix'))

##' Replace model matrix
##'
##' @param object LMlike or subclass
##' @param value matrix
##' @return modify object
setGeneric('model.matrix<-', function(object, value) standardGeneric('model.matrix<-'))


##' Return programmatically useful summary of a fit
##'
##' @param object LMlike or subclass
##' @param ... other arguments
##' @return list of parameters characterizing fit
setGeneric('summarize', function(object, ...) standardGeneric('summarize'))


###############################
## old style LRT
###############################
##' Likelihood Ratio Tests for SingleCellAssays
##'
##' Tests for a change in ET binomial proportion or mean of positive ET
##' Likelihood Ratio Test for SingleCellAssay objects
##'
##' Combined Likelihood ratio test (binomial and normal) for SingleCellAssay and derived objects.
##' This function is deprecated, please use \link{lrTest} instead.
##' @seealso zlm ZlmFit
##' @param ... ignored
##' @export
setGeneric("LRT",function(sca,comparison,...) standardGeneric("LRT"))

