% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/051.imputation_bkb.predictors.R
\name{imputation_bkb.predictors}
\alias{imputation_bkb.predictors}
\title{Imputing the unmeasured well-specific markers with regression models}
\usage{
imputation_bkb.predictors(
  paths,
  chans,
  yvar = "Legend",
  cores = 4L,
  models.use,
  extra_args_regression_params,
  prediction_events_downsampling = NULL,
  impu.training,
  plots = TRUE
)
}
\arguments{
\item{paths}{a vector of characters of paths to store intput, intermediary results, outputs...}

\item{chans}{a vector of the names of the backbone markers (MUST match to the names in the FCS file).}

\item{yvar}{the name of the well-specific marker in the FCS files (has been changed to "Legend" in the first function).}

\item{cores}{the number of cores used to perform parallel computation (default = 8L).}

\item{models.use}{a vector of the names of the models used for imputation (an example: \code{c("LM", "LASSO3", "SVM", "XGBoost")}). The length of the vector is arbitrary.}

\item{extra_args_regression_params}{a list of the lists of the parameters for running regression models.}

\item{prediction_events_downsampling}{default = NULL (not doing subsampling). How many cells per well you want to have the imputation? (must be less than or equal to a half as we won't get the prediction for cells in the training set).}

\item{impu.training}{logical; if FALSE (default), not impute the training set (the dataset used to train the imputation models).}

\item{plots}{logical; if TRUE (default), visualise the distribution of R-sq from each infinity marker.}
}
\value{
A list of imputations
}
\description{
This function has been designed to impute/predict the unmeasured well-specific markers with regression models.
}
\details{
This function returns the object of imputation of the unmeasured well-specific markers. In the output directory, the imputations are saved to predictions.Rds file. Visualisation of the imputation accuracy will be provided if specified.
}
\author{
Hsiao-Chi Liao and InfinityFlow (Becht et. al, 2021)
}
