% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_class_MQ.R
\name{new_class_MQ}
\alias{new_class_MQ}
\title{Create a new MACSQuant object}
\usage{
#initialize empty MACSQuant object
new_class_MQ(my_data=NULL,my_data_sorted=NULL,my_replicates_sorted=NULL,
experiment_name=NULL,statistics=NULL,combination.index.df=NULL,
number_of_replicates=NULL,number_of_conditions=NULL,doses=NULL,
doses.alt=NULL,c_names=NULL, control=NULL,plt.title=NULL,
plt.labels=NULL,plt.col=NULL,save.files=NULL,path=tempdir())
#initialize custom MACSQuant object
new_class_MQ(my_data,my_data_sorted=NULL,my_replicates_sorted=NULL,
experiment_name=NULL,statistics=NULL,combination.index.df=NULL,
number_of_replicates=NULL,number_of_conditions=NULL,
doses=NULL,doses.alt=NULL, c_names=NULL,control=NULL,plt.title=NULL,
plt.labels=NULL,plt.col=NULL, save.files=NULL,path=tempdir())
}
\arguments{
\item{my_data}{Contains the raw data}

\item{my_data_sorted}{Contains the sorted data
(according to replicates order)}

\item{my_replicates_sorted}{Contains the sorted matrix containing
replicates names}

\item{experiment_name}{User defined experiment named. Used for the
report generation}

\item{statistics}{Contains the statistics for each condition}

\item{combination.index.df}{data.frame that contains the outputs of
the combination_index function}

\item{number_of_replicates}{For each condition, the number of duplicates
(must be the same for all conditions)}

\item{number_of_conditions}{The number of conditions tested
(eg: Drug 1 alone, Drug 2 alone)}

\item{doses}{Numeric vector representing doses for each conditions}

\item{doses.alt}{In case of interaction test second dose vector}

\item{c_names}{Vector containing experiment names}

\item{control}{logical: is there a control in this experiment
(eg: Staurosporin)}

\item{plt.title}{Title of the experiment to add to the barplot}

\item{plt.labels}{legend labels for the bar plot}

\item{plt.col}{color vector for the graphical representations}

\item{save.files}{Used to save the image in the output folder}

\item{path}{path of the experiment output folder (default '.')}
}
\value{
A formatted report file along with intermediates results
}
\description{
The user can create a new custom MACSQuant object
This function is also used in internal code for
MACSQuant initialization
}
\examples{
# initialize empty MACSQuant object
new_class_MQ()
# initialize custom MACSQuant object
my_data <- data.frame(character(length = 10), character(length = 10),
    numeric(length = 10), numeric(length = 10))
names(my_data) <- c("Full path", "WID", "\%-#", "Count/mL")
new_class_MQ(my_data)
}
