% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ledpred.R
\name{LedPred}
\alias{LedPred}
\title{Creates an SVM model given a feature matrix}
\usage{
LedPred(data = NULL, cl = 1, ranges = list(gamma = c(1, 10), cost = c(1,
  10)), cost = NULL, gamma = NULL, kernel = "linear", valid.times = 10,
  file.prefix = NULL, numcores = ifelse(.Platform$OS.type == "windows", 1,
  parallel::detectCores() - 1), step.nb = 10, halve.above = 100)
}
\arguments{
\item{data}{data.frame containing the training set}

\item{cl}{integer indicating the column number corresponding to the response vector that classify positive and negative regions (default = 1)}

\item{ranges}{list object containing one (linear kernel) or two (radial kernel) vectors of integers corresponding to SVM cost and SVM gamma parameters to test.}

\item{cost}{The SVM cost parameter for both linear and radial kernels. If NULL (default), the function \code{mcTune} is run.}

\item{gamma}{The SVM gamma parameter for radial kernel. If radial kernel and NULL (default), the function \code{mcTune} is run.}

\item{kernel}{SVM kernel, a character string: "linear" or "radial". (default = "radial")}

\item{valid.times}{Integer indicating how many times the training set will be split for the cross validation step (default = 10). This number must be smaller than positive and negative sets sizes.}

\item{file.prefix}{A character string that will be used as a prefix for the result files. If it is NULL (default), no plot is returned}

\item{numcores}{Number of cores to use for parallel computing (default: the number of available cores in the machine - 1)}

\item{step.nb}{Number of features to add at each step (default = 10)}

\item{halve.above}{During RFE, all the features are ranked at the first round and the half lowest ranked features (that contribute the least in the model) are removed for the next round. When the number of feauture is lower or equal to halve.above, the features are removed one by one. (default=100)}
}
\value{
A list of the object produced at each step
\item{best.params}{A list of the parameters giving the lowest misclassification error}
\item{feature.ranking}{List of ordered features from \code{rankFeatures}}
\item{feature.nb}{he optimal number of feature to use from the list of ordered features from \code{tuneFeatureNb}}
\item{model.svm}{The best SVM model \code{createModel}}
\item{probs.label.list}{The cross-validation results from \code{evaluateModelPerformance}}
}
\description{
The \code{LedPred} function computes the best SVM parameters, defines the optimal features for creating the SVM model by running sequentially \code{mcTune},  \code{rankFeatures},  \code{tuneFeatureNb} and  \code{createModel}. The performances of this model are then computed usong \code{evaluateModelPerformance}.
}
\examples{
 data(crm.features)
 #cost_vector <- c(1,3,10)
 #gamma_vector <- c(1,3,10)
 #ledpred.list=LedPred(data.granges=crm.features, cl=1, ranges = list(cost=cost_vector,
 #                          gamma=gamma_vector), kernel="linear", halve.above=50)
 #names(ledpred.list)
}

