% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_trn.R
\name{svm_trn}
\alias{svm_trn}
\title{svm_trn allows assessing the final DEGs through a machine learning step by using svm in a cross validation process.}
\usage{
svm_trn(data, labels, vars_selected, numFold = 10)
}
\arguments{
\item{data}{The data parameter is an expression matrix or data.frame that contains the genes in the columns and the samples in the rows.}

\item{labels}{A vector or factor that contains the labels for each of the samples in the data object.}

\item{vars_selected}{The genes selected to classify by using them. It can be the final DEGs extracted with the function \code{\link{DEGsExtraction}} or a custom vector of genes. Furthermore, the ranking achieved by \code{\link{featureSelection}} function can be used as input of this parameter.}

\item{numFold}{The number of folds to carry out in the cross validation process.}
}
\value{
A list that contains five objects. The confusion matrix for each fold, the accuracy, the sensitibity and the specificity for each fold and each genes, and a vector with the best parameters found for the SVM algorithm after tuning.
}
\description{
svm_trn allows assessing the final DEGs through a machine learning step by using svm in a cross validation process. This function applies a cross validation of n folds with representation of all classes in each fold. The 80\% of the data are used for training and the 20\% for test. An optimization of C and G hiperparameters is done at the start of the process.
}
\examples{
dir <- system.file("extdata", package = "KnowSeq")
load(paste(dir, "/expressionExample.RData", sep = ""))

svm_trn(t(DEGsMatrix)[,1:10], labels, rownames(DEGsMatrix)[1:10], 2)
}
