% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateGeneExpressionValues.R
\name{calculateGeneExpressionValues}
\alias{calculateGeneExpressionValues}
\title{Calculates the gene expression values by using a matrix of counts from RNA-seq.}
\usage{
calculateGeneExpressionValues(
  countsMatrix,
  annotation,
  genesNames = TRUE,
  notHuman = FALSE,
  notHumanGeneLengthCSV = "",
  Ensembl_ID = TRUE
)
}
\arguments{
\item{countsMatrix}{The original counts matrix returned by \code{\link{countsToMatrix}} function or a matrix with the gene Ensembl ID in the rows and the samples in the columns that contains the count values.}

\item{annotation}{A matrix that contains the Ensembl IDs, the gene name and the percentage gene gc content for the genes available in the expression matrix. This annotation could be extracted from the function \code{\link{getGenesAnnotation}}.}

\item{genesNames}{A boolean variable which indicates if the rownames of the expression matrix are the genes Names (Symbols) or the ensembl IDs.}

\item{notHuman}{A boolean variable which indicates if the gene length file is the default gene length human file or another file indicated by parameter.}

\item{notHumanGeneLengthCSV}{Path to the CSV file that contains the gene length of the specie to use.}

\item{Ensembl_ID}{A boolean variable which indicate if the counts matrix contains Ensembl_ID(TRUE) or genes names(FALSE).}
}
\value{
A matrix that contains the gene expression values. The rownames are the genes names or the Ensembl IDs and the colnames are the samples.
}
\description{
Calculates the gene expression values by using a matrix of counts from RNA-seq. Furthermore, the conversion from Ensembl IDs to genes names is performed by default, but can be changed with the parameter genesNames.
}
\examples{
dir <- system.file("extdata", package="KnowSeq")
load(paste(dir,"/expressionExample.RData",sep = ""))

expressionMatrix <- calculateGeneExpressionValues(countsMatrix,myAnnotation, genesNames = TRUE)
}
