% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_mappings.R
\name{generate_mappings}
\alias{generate_mappings}
\title{The 'boilerplate' for this package's desired graph style}
\usage{
generate_mappings(style_name, map_edge_width, edge_width_attribute,
  min_score, max_score)
}
\arguments{
\item{style_name}{An argument to name style; when used inside 
of \code{\link{cyto_vis}} no name is needed}

\item{map_edge_width}{A logical indicator; if FALSE no continuous mapping 
of edge width will be applied}

\item{edge_width_attribute}{The attribute that will be used for edge width; 
if data is not added or the attribute is not part of the graphing 
information, the edge width will default to 1.}

\item{min_score}{The minimum attribute value for the column used to map 
edge width}

\item{max_score}{The maximum attribute value for the column used to map 
edge width}
}
\value{
A list that can be converted to a JSON file to apply desired 
style/layout in Cytoscape
}
\description{
Generates an object that can be converted to a JSON file 
and subsequently applied to the graph for the markup specified by this
 package and the layout mirroring KEGG.
Intended for use within \code{\link{cyto_vis}}
}
\examples{
style.name = "myKEGGstyle"
mappings <- generate_mappings(style.name, FALSE)
}
