% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_KEGG_edges.R
\name{expand_KEGG_edges}
\alias{expand_KEGG_edges}
\title{Get detailed KEGG mapping information for each relation [edge] documented 
in KEGG}
\usage{
expand_KEGG_edges(KGML_file, KEGG_mappings)
}
\arguments{
\item{KGML_file}{An object of formal class KEGGPathway}

\item{KEGG_mappings}{The data.frame object generated by the function 
expand_KEGG_mappings}
}
\value{
A dataframe object with unique entry information for all edges 
documented in the KEGG pathway. 
        Note that each row has a unique combination of values for
         (entry1, entry2, entry1symbol, entry2symbol).
}
\description{
Extract relationship information from KGML object and re-map
 based on normalized node information
}
\examples{
p53_KGML <- get_KGML("hsa04115")
p53_KEGG_mappings <- expand_KEGG_mappings(p53_KGML, FALSE)
p53_edges <- expand_KEGG_edges(p53_KGML, p53_KEGG_mappings)
}
