% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_pc_boosting.R
\name{kernel_pc_boosting}
\alias{kernel_pc_boosting}
\title{Function to perform Kernel Principal Component Boosting}
\usage{
kernel_pc_boosting(X, Y, g, v, ite, thr)
}
\arguments{
\item{X}{A matrix with the explanatory variables.}

\item{Y}{a matrix with the variable to predict.}

\item{g}{a positive number with the width parameter for the RBF Kernel.}

\item{v}{a number between 0 and 1 that corresponds to the shrinkage parameter.}

\item{ite}{an integer with the number of iterations.}

\item{thr}{a threshold to discard Kernel principal components whose eigenvalue}
}
\value{
function an sum of squared errors.
}
\description{
Function to perform Kernel Principal Component Boosting
}
\examples{
data(D4_multi_1)
Y = scale(matrix(D4_multi_1[,91],100,1))
X = scale(D4_multi_1[,-91])
res = kernel_pc_boosting(X,Y, g= 40, v = 0.5, ite = 3, thr = 1e-10)
}
