% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_upload.R
\name{read.SCsignalR}
\alias{read.SCsignalR}
\title{Read output from SingleCellSignalR}
\usage{
read.SCsignalR(folder)
}
\arguments{
\item{folder}{containing output from SingleCellSignalR, named cell-signaling}
}
\value{
input.data: preprocessed object with annotated L-R pairs
}
\description{
SCSR description: the output folder is a collection of txt files, 
one for each 
clusters pair considered. The "paracrine" option looks for ligands expressed 
in cluster A and their associated receptors according to LRdb that are
 expressed in any other cluster but A. These interactions are labelled 
 "paracrine". The interactions that involve a ligand and a receptor, both 
 differentially expressed in their respective cell clusters according to 
 the **edgeR** analysis performed by the **cluster_analysis()** function, 
 are labelled "specific". The "autocrine" option searches for ligands 
 expressed in cell cluster A and their associated receptors also expressed 
 in A. These interactions are labelled "autocrine". Additionally, it searches
 for those associated receptors in the other cell clusters (not A) to cover 
 the part of the signaling that is "autocrine" and "paracrine" 
 simultaneously. These interactions are labelled "autocrine/paracrine".
 This file is a 4-column table: ligands, receptors, interaction types 
 ("paracrine", "autocrine", "autocrine/paracrine" and "specific"),
 and the associated LRscore. 
 InterCellar: rename autocrine|paracrine to paracrine
}
