% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purity-filter.R
\name{purity_filter}
\alias{purity_filter}
\title{Filter integration sites based on purity.}
\usage{
purity_filter(
  x,
  lineages = blood_lineages_default(),
  aggregation_key = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  group_key = c("CellMarker", "Tissue"),
  selected_groups = NULL,
  join_on = "CellMarker",
  min_value = 3,
  impurity_threshold = 10,
  by_timepoint = TRUE,
  timepoint_column = "TimePoint",
  value_column = "seqCount_sum"
)
}
\arguments{
\item{x}{An aggregated integration matrix, obtained via
\code{aggregate_values_by_key()}}

\item{lineages}{A data frame containing cell lineages information}

\item{aggregation_key}{The key used for aggregating \code{x}}

\item{group_key}{A character vector of column names for re-aggregation.
Column names must be either in \code{x} or in \code{lineages}. See details.}

\item{selected_groups}{Either NULL, a character vector or a
data frame for group selection. See details.}

\item{join_on}{Common columns to perform a join operation on}

\item{min_value}{A minimum value to filter the input matrix. Integrations
with a value strictly lower than \code{min_value} are excluded (dropped) from
the output.}

\item{impurity_threshold}{The ratio threshold for impurity in groups}

\item{by_timepoint}{Should filtering be applied on each time point? If
\code{FALSE}, all time points are merged together}

\item{timepoint_column}{Column in \code{x} containing the time point}

\item{value_column}{Column in \code{x} containing the numeric
quantification of interest}
}
\value{
A data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Filter that targets possible contamination between cell lines based on
a numeric quantification (likely abundance or sequence count).
}
\details{
\subsection{Setting input arguments}{

The input matrix can be re-aggregated with the provided \code{group_key}
argument. This key contains the names of the columns to group on
(besides the columns holding genomic coordinates of the integration
sites) and must be contained in at least one of \code{x} or \code{lineages}
data frames. If the key is not found only in \code{x}, then a join operation
with the \code{lineages} data frame is performed on the common column(s)
\code{join_on}.
}

\subsection{Group selection}{

It is possible for the user to specify on which groups the logic of the
filter should be applied to. For example: if we have
\code{group_key = c("HematoLineage")} and we set
\code{selected_groups = c("CD34", "Myeloid","Lymphoid")}
it means that a single integration will be evaluated for the filter only
for groups that have the values of "CD34", "Myeloid" and "Lymphoid" in
the "HematoLineage" column.
If the same integration is present in other groups it is
kept as it is. \code{selected_groups} can be set to \code{NULL} if we want
the logic to apply to every group present in the data frame,
it can be set as a simple character vector as the example above if
the group key has length 1 (and there is no need to filter on time point).
If the group key is longer than 1 then the filter is applied only on the
first element of the key.

If a more refined selection on groups is needed, a data frame can
be provided instead:

\if{html}{\out{<div class="sourceCode">}}\preformatted{group_key = c("CellMarker", "Tissue")
selected_groups = tibble::tribble(
~ CellMarker, ~ Tissue,
"CD34", "BM",
"CD14", "BM",
"CD14", "PB"
)
}\if{html}{\out{</div>}}

Columns in the data frame should be the same as group key (plus,
eventually, the time point column). In this example only those groups
identified by the rows in the provided data frame are processed.
}
}
\examples{
data("integration_matrices", package = "ISAnalytics")
data("association_file", package = "ISAnalytics")
aggreg <- aggregate_values_by_key(
    x = integration_matrices,
    association_file = association_file,
    value_cols = c("seqCount", "fragmentEstimate")
)
filtered_by_purity <- purity_filter(
    x = aggreg,
    value_column = "seqCount_sum"
)
head(filtered_by_purity)
}
\seealso{
Other Data cleaning and pre-processing: 
\code{\link{aggregate_metadata}()},
\code{\link{aggregate_values_by_key}()},
\code{\link{compute_near_integrations}()},
\code{\link{default_meta_agg}()},
\code{\link{outlier_filter}()},
\code{\link{outliers_by_pool_fragments}()},
\code{\link{realign_after_collisions}()},
\code{\link{remove_collisions}()},
\code{\link{threshold_filter}()}
}
\concept{Data cleaning and pre-processing}
