% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis-functions.R
\name{top_targeted_genes}
\alias{top_targeted_genes}
\title{Top n targeted genes based on number of IS.}
\usage{
top_targeted_genes(
  x,
  n = 20,
  key = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  consider_chr = TRUE,
  consider_gene_strand = TRUE,
  as_df = TRUE
)
}
\arguments{
\item{x}{An integration matrix - must be annotated}

\item{n}{Number of rows to slice}

\item{key}{If slice has to be performed for each group, the character
vector of column names that identify the groups. If \code{NULL} considers the
whole input data frame.}

\item{consider_chr}{Logical, should the chromosome be taken into account?
See details.}

\item{consider_gene_strand}{Logical, should the gene strand be taken into
account? See details.}

\item{as_df}{If computation is performed by group, \code{TRUE} returns all
groups merged in a single data frame with a column containing the group id.
If \code{FALSE} returns a named list.}
}
\value{
A data frame or a list of data frames
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Produces a summary of the number of integration events per gene, orders
the table in decreasing order and slices the first n rows - either on
all the data frame or by group.
}
\details{
\subsection{Gene grouping}{

When producing a summary of IS by gene, there are different options that
can be chosen.
The argument \code{consider_chr} accounts for the fact that some genes (same
gene symbol) may span more than one chromosome: if set to \code{TRUE}
counts of IS will be separated for those genes that span 2 or more
chromosomes - in other words they will be in 2 different rows of the
output table. On the contrary, if the argument is set to \code{FALSE},
counts will be produced in a single row.

NOTE: the function counts \strong{DISTINCT} integration events, which logically
corresponds to a union of sets. Be aware of the fact that counts per group
and counts with different arguments might be different: if for example
counts are performed by considering chromosome and there is one gene symbol
with 2 different counts, the sum of those 2 will likely not be equal to
the count obtained by performing the calculations without
considering the chromosome.

The same reasoning can be applied for the argument \code{consider_gene_strand},
that takes into account the strand of the gene.
}
}
\section{Required tags}{

The function will explicitly check for the presence of these tags:
\itemize{
\item chromosome
\item locus
\item gene_symbol
\item gene_strand
}

Note that the tags "gene_strand" and "chromosome" are explicitly required
only if \code{consider_chr = TRUE} and/or \code{consider_gene_strand = TRUE}.
}

\examples{
data("integration_matrices", package = "ISAnalytics")
top_targ <- top_targeted_genes(
    integration_matrices,
    key = NULL
)
top_targ
}
\seealso{
Other Analysis functions: 
\code{\link{CIS_grubbs}()},
\code{\link{HSC_population_size_estimate}()},
\code{\link{compute_abundance}()},
\code{\link{cumulative_is}()},
\code{\link{gene_frequency_fisher}()},
\code{\link{is_sharing}()},
\code{\link{iss_source}()},
\code{\link{sample_statistics}()},
\code{\link{top_integrations}()}
}
\concept{Analysis functions}
