% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/processingRateDelay-methods.R
\name{processingDelay}
\alias{processingDelay}
\alias{calculateDelta}
\alias{calculateTau}
\alias{processingDelay,INSPEcT-method}
\alias{calculateTau,INSPEcT-method}
\alias{calculateDelta,INSPEcT-method}
\title{Classify genes as delayed by the processing using the delta and tau metrics}
\usage{
processingDelay(
  inspectIds,
  tauThreshold = 1.2,
  deltaThreshold = 1,
  silent = TRUE
)

calculateDelta(inspectIds, silent = FALSE)

calculateTau(inspectIds, silent = FALSE)

\S4method{processingDelay}{INSPEcT}(
  inspectIds,
  tauThreshold = 1.2,
  deltaThreshold = 1,
  silent = TRUE
)

\S4method{calculateTau}{INSPEcT}(inspectIds, silent = FALSE)

\S4method{calculateDelta}{INSPEcT}(inspectIds, silent = FALSE)
}
\arguments{
\item{inspectIds}{An object of class INSPEcT.}

\item{tauThreshold}{A numeric representing the tau threshold to define a gene affected by processing. Default: 1.2}

\item{deltaThreshold}{A numeric representing the delta threshold to define a gene affected by processing. Default: 1.0}

\item{silent}{A logical indicating whether informaiton about the procedure should be printed or not.}
}
\description{
These functions calculates the tau and delta metrics for all genes with introns and exons in an oblect of class INSPEcT.
If the INSPEcT dataset was obtained with nascent RNA the metrics are caluclated using RNA dynamics and solving numerically the system of equations.
If the INSPEcT dataset was obtained without nascent RNA the metrics are approximated using premature and mature levels.
}
\examples{
data('allcounts', package='INSPEcT')
data('featureWidths', package='INSPEcT')
data('libsizes', package='INSPEcT')

nascentCounts<-allcounts$nascent
matureCounts<-allcounts$mature
conditions<-c(0,1/6,1/3,1/2,1,1.5,2,4,8,12,16)
expDes<-rep(conditions,3)
tL <- 1/6

nasExp_DESeq2<-quantifyExpressionsFromTrCounts(
      allcounts=matureCounts
      ,libsize=totalLS
      ,exonsWidths=exWdths
      ,intronsWidths=intWdths
      ,experimentalDesign=expDes)

matExp_DESeq2<-quantifyExpressionsFromTrCounts(
      allcounts=matureCounts
      ,libsize=totalLS
      ,exonsWidths=exWdths
      ,intronsWidths=intWdths
      ,experimentalDesign=expDes)

matureInspObj <- newINSPEcT(
      tpts=conditions
      ,labeling_time=tL
      ,nascentExpressions=nasExp_DESeq2
      ,matureExpressions=matExp_DESeq2)

procDelay<- processingDelay(inspectIds=matureInspObj
      ,tauThreshold=1.2
      ,deltaThreshold=1.0)

head(procDelay)
table(procDelay)

head(calculateTau(matureInspObj))

head(calculateDelta(matureInspObj))

}
