% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{RunTSNE}
\alias{RunTSNE}
\alias{RunTSNE.SingleCellExperiment}
\alias{RunTSNE,SingleCellExperiment-method}
\title{Barnes-Hut implementation of t-Distributed Stochastic
Neighbor Embedding (t-SNE)}
\usage{
RunTSNE.SingleCellExperiment(object, perplexity)

\S4method{RunTSNE}{SingleCellExperiment}(object, perplexity = 30)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{perplexity}{perplexity of t-SNE}
}
\value{
object of \code{SingleCellExperiment} class
}
\description{
Run nonlinear dimensionality reduction using t-SNE with the
PCA-transformed consensus matrix as input.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- RunTSNE(sce)

}
\keyword{Barnes-Hut}
\keyword{Embedding}
\keyword{Neighbor}
\keyword{Stochastic}
\keyword{implementation}
\keyword{of}
\keyword{t-Distributed}
\keyword{t-SNE}
