% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{FindGeneMarkers}
\alias{FindGeneMarkers}
\alias{FindGeneMarkers.SingleCellExperiment}
\alias{FindGeneMarkers,SingleCellExperiment-method}
\title{Identification of gene markers for a cluster or two arbitrary
combinations of clusters}
\usage{
FindGeneMarkers.SingleCellExperiment(
  object,
  clusters.1,
  clusters.2,
  clustering.type,
  test,
  logfc.threshold,
  min.pct,
  min.diff.pct,
  min.cells.group,
  max.cells.per.cluster,
  pseudocount.use,
  return.thresh,
  only.pos
)

\S4method{FindGeneMarkers}{SingleCellExperiment}(
  object,
  clusters.1 = NULL,
  clusters.2 = NULL,
  clustering.type = "",
  test = "wilcox",
  logfc.threshold = 0.25,
  min.pct = 0.1,
  min.diff.pct = NULL,
  min.cells.group = 3,
  max.cells.per.cluster = NULL,
  pseudocount.use = 1,
  return.thresh = 0.01,
  only.pos = FALSE
)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{clusters.1}{a character or numeric vector denoting which clusters
to use in the first group (named group.1 in the results)}

\item{clusters.2}{a character or numeric vector denoting which clusters
to use in the second group (named group.2 in the results)}

\item{clustering.type}{"manual" or "optimal". "manual" refers to the
clustering formed using the "SelectKClusters" function and "optimal" to
the clustering formed using the "CalcSilhInfo" function.
Default is "manual".}

\item{test}{Which test to use. Only "wilcoxon" (the Wilcoxon rank-sum test,
AKA Mann-Whitney U test) is supported at the moment.}

\item{logfc.threshold}{Filters out genes that have log2 fold-change of the
averaged gene expression values (with the pseudo-count value added to the
averaged values before division if pseudocount.use > 0) below this threshold.
Default is \code{0.25}.}

\item{min.pct}{Filters out genes that have dropout rate (fraction of cells
expressing a gene) below this threshold in both comparison groups
Default is \code{0.1}.}

\item{min.diff.pct}{Filters out genes that do not have this minimum
difference in the dropout rates (fraction of cells expressing a gene)
between the two comparison groups. Default is \code{NULL}.}

\item{min.cells.group}{The minimum number of cells in the two comparison
groups to perform the DE analysis. If the number of cells is below the
threshold, then the DE analysis is not performed.
Default is \code{3}.}

\item{max.cells.per.cluster}{The maximun number of cells per cluster
if downsampling is performed to speed up the DE analysis.
Default is \code{NULL}, i.e. no downsampling.}

\item{pseudocount.use}{A positive integer, which is added
to the average gene expression values before calculating the fold-change.
This makes sure that no divisions by zero occur. Default is \code{1}.}

\item{return.thresh}{If only.pos=TRUE, then return only genes that
have the adjusted p-value (adjusted by the Bonferroni method) below or
equal to this threshold.  Default is \code{0.01}.}

\item{only.pos}{Whether to return only genes that have an adjusted
p-value (adjusted by the Bonferroni method) below or equal to the
threshold. Default is \code{FALSE}.}
}
\value{
a data frame of the results if positive results were found, else NULL
}
\description{
FindGeneMarkers enables identifying gene markers for one cluster or
two arbitrary combinations of clusters, e.g. 1_2 vs. 3_4_5.
Gene and cell filters can be applied to accelerate
the analysis, but this might lead to missing weak signals.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- SelectKClusters(sce,K=5)
gene_markes_1 <- FindGeneMarkers(sce,clusters.1=1)
gene_markes_1_vs_2 <- FindGeneMarkers(sce,clusters.1=1,clusters.2=2)

}
\keyword{DE}
\keyword{analysis}
\keyword{differential}
\keyword{expression}
\keyword{gene}
\keyword{markers}
