% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{AnnotationScatterPlot}
\alias{AnnotationScatterPlot}
\alias{AnnotationScatterPlot.SingleCellExperiment}
\alias{AnnotationScatterPlot,SingleCellExperiment-method}
\title{Visualiation of a custom annotation over nonlinear
dimensionality reduction}
\usage{
AnnotationScatterPlot.SingleCellExperiment(
  object,
  annotation,
  return.plot,
  dim.reduction.type,
  point.size,
  show.legend
)

\S4method{AnnotationScatterPlot}{SingleCellExperiment}(
  object,
  annotation = NULL,
  return.plot = FALSE,
  dim.reduction.type = "",
  point.size = 0.7,
  show.legend = FALSE
)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{annotation}{a character vector, factor or numeric for the class labels.}

\item{return.plot}{return.plot whether to return the ggplot2 object or
just draw it. Default is \code{FALSE}.}

\item{dim.reduction.type}{"tsne" or "umap". Default is \code{tsne}.}

\item{point.size}{point size. Default is \code{0.7}.}

\item{show.legend}{a logical denoting whether to show the legend on the right
side of the plot. Default is \code{TRUE}.}
}
\value{
ggplot2 object if return.plot=TRUE
}
\description{
The AnnotationScatterPlot enables visualizing arbitrary class labels
over the nonliner dimensionality reduction, e.g. t-SNE or UMAP.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- RunTSNE(sce)
sce <- HierarchicalClustering(sce)
sce <- SelectKClusters(sce,K=5)
## Change the names to the first five alphabets and Visualize the annotation.
custom_annotation <- plyr::mapvalues(metadata(sce)$iloreg$clustering.manual,
                                     c(1,2,3,4,5),
                                     LETTERS[1:5])
AnnotationScatterPlot(sce,
                      annotation = custom_annotation,
                      return.plot = FALSE,
                      dim.reduction.type = "tsne",
                      show.legend = FALSE)


}
\keyword{annotation}
\keyword{custom}
\keyword{dimensionality}
\keyword{nonlinear}
\keyword{reduction}
\keyword{t-sne}
\keyword{umap}
\keyword{visualization}
