% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_expression_triangle}
\alias{plot_expression_triangle}
\title{Plot a triangle of comparisons of DEG sets among generations}
\usage{
plot_expression_triangle(deg_counts, palette = NULL, box_labels = NULL)
}
\arguments{
\item{deg_counts}{Data frame with number of differentially expressed
genes per contrast as returned by \code{get_deg_counts}.}

\item{palette}{Character vector of length 4 indicating the colors of the
boxes for P1, P2, F1, and midparent, respectively. If NULL,
a default color palette will be used.}

\item{box_labels}{Character vector of length 4 indicating the labels of the
boxes for P1, P2, F1, and midparent, respectively. Default: NULL, which
will lead to labels "P1", "P2",
"F1", and "Midparent", respectively.}
}
\value{
A ggplot object with an expression triangle.
}
\description{
Plot a triangle of comparisons of DEG sets among generations
}
\details{
The expression triangle plot shows the number of differentially expressed
genes (DEGs) for each contrast. Numbers in the center of the lines (in bold)
indicate the total number of DEGs, while numbers near boxes indicate
the number of up-regulated genes in each generation of the triangle.
}
\examples{
data(deg_counts)
plot_expression_triangle(deg_counts)
}
