% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{collections}
\alias{collections}
\alias{collections_default_columns}
\alias{collection_detail}
\alias{collection_contacts}
\alias{collection_data}
\alias{collection_contributors}
\title{HuBMAP Collections}
\usage{
collections()

collections_default_columns(as = c("tibble", "character"))

collection_detail(uuid)

collection_contacts(uuid)

collection_data(uuid)

collection_contributors(uuid)
}
\arguments{
\item{as}{character(1) return format. One of \code{"tibble"} (default),
or \code{"character"}.}

\item{uuid}{character(1) corresponding to the HuBMAP Collection UUID
string. This is expected to be a 32-digit hex number.}
}
\value{
\verb{*_columns()} returns a named list \code{name}
containing the column name used in the tibble returned by
\code{samples()}, \code{datasets()},  \code{donors()},
\code{collections()},  or \code{publications()}.
When \code{as = "tibble"},the return value is a tibble
with paths as elements and abbreviations as names.
}
\description{
\code{collections()} returns details about available collections,
ordered by last modified dates

\verb{*_columns()} returns a tibble or named
character vector describing the content of the tibble returned
by \code{samples()}, \code{datasets()},  \code{donors()}, \code{collections()},
or \code{publications()}.

\code{collection_detail()} takes a unique collection_id and
returns details about one specified collection as a tibble

\code{collection_contacts()} takes a unique collection_id and
returns contacts information of one specified collection as a tibble

\code{collection_data()} takes a unique collection_id and
returns related datasets of one specified collection as a tibble

\code{collection_contributors()} takes a unique collection_id and
returns contributors information of one specified collection as a tibble
}
\details{
Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis

Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis

Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis

Additional details are provided on the HuBMAP consortium
webpage, https://software.docs.hubmapconsortium.org/apis
}
\examples{
collections()
collections_default_columns()

uuid <- "a320abcf56241be2e5e453401efeaaf3"
collection_detail(uuid)
uuid <- "381f65e58d5e2c1d16a9cef2cc203aab"
collection_contacts(uuid)
uuid <- "381f65e58d5e2c1d16a9cef2cc203aab"
collection_data(uuid)
uuid <- "590b0485a196956284b8f3344276bc50"
collection_contributors(uuid)
}
