% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportHiC.R
\name{ImportHiC}
\alias{ImportHiC}
\title{Import Hic data}
\usage{
ImportHiC(
  file = NULL,
  hicResolution = NULL,
  chromSizes = NULL,
  chrom_1 = NULL,
  chrom_2 = NULL,
  verbose = FALSE,
  cores = 1,
  hic_norm = "NONE",
  hic_matrix = "observed",
  cool_balanced = FALSE,
  cool_weight_name = "weight",
  cool_divisive_weights = FALSE,
  h5_fill_upper = TRUE
)
}
\arguments{
\item{file}{<GRanges or Pairs\link{GRanges} or GInteractions>:
The genomic feature on which compute the extraction of HiC submatrix.
Extension should be .hic, .cool, .mcool, .h5, .hdf5, .HDF5 or .bedpe"
assuming .h5 and .hdf5 are only for cool (not mcool).}

\item{hicResolution}{\if{html}{\out{<numeric>}}: The HiC resolution.}

\item{chromSizes}{<data.frame>: A data.frame where first
colum correspond to the chromosomes names, and the second column correspond
to the chromosomes lengths in base pairs.}

\item{chrom_1}{\if{html}{\out{<numeric>}}: The seqnames of first chromosmes
(rows in matrix).}

\item{chrom_2}{\if{html}{\out{<numeric>}}: The seqnames of second chromosmes
(col in matrix).
If \code{NULL} variable will be assigned value of chrom_1 (Defalt NULL).}

\item{verbose}{\if{html}{\out{<logical>}}: Show the progression in console?
(Default FALSE)}

\item{cores}{\if{html}{\out{<numerical>}} : An integer to specify the number
of cores. (Default 1)}

\item{hic_norm}{\if{html}{\out{<character>}}: "norm" argument to supply to
\code{\link[strawr:straw]{strawr::straw()}}.
This argument is for .hic format data only. Available norms can be obtained
through \code{\link[strawr:readHicNormTypes]{strawr::readHicNormTypes()}}.
(Default "NONE").}

\item{hic_matrix}{\if{html}{\out{<character>}}: "matrix" argument to supply to
\code{\link[strawr:straw]{strawr::straw()}}.
This argument is for .hic format data only.
Other options can be: "oe", "expected". (Default "observed").}

\item{cool_balanced}{\if{html}{\out{<logical>}} Import already balanced matrix?
(Default: FALSE)}

\item{cool_weight_name}{\if{html}{\out{<character>}} Name of the correcter in
the cool file. (Default: weight).
\code{\link[rhdf5:h5ls]{rhdf5::h5ls()}} to see the available correctors.}

\item{cool_divisive_weights}{\if{html}{\out{<logical>}} Does the correcter
vector contain divisive biases as in hicExplorer or multiplicative as in
cooltools? (Default: FALSE)}

\item{h5_fill_upper}{\if{html}{\out{<logical>}} Do the matrix in h5 format
need to be transposed? (Default: TRUE)}
}
\value{
A matrices list.
}
\description{
Import ..hic, .cool, .mcool or .bedpe data
}
\details{
ImportHiC

If you request "expected" values when importing .hic format data,
you must do yourself the "oe" by importing manually the observed counts
as well.

Prior to v.0.9.0 cooltools had multiplicative weight only, so make sure
your correcters are divisive or multiplicative.
https://cooler.readthedocs.io/en/stable/releasenotes.html#v0-9-0

When loading hic matrix in h5 format make sure you have enough momory
to load the full matrix with all chromosomes regardless of values for
chrom_1 and chrom_2 arguments. The function first loads the whole matrix,
then extracts matrices per chromosome for the time being, it's easier ;).
}
\examples{
\donttest{

# Prepare Temp Directory
options(timeout = 3600)
temp.dir <- file.path(tempdir(), "HIC_DATA")
dir.create(temp.dir)

# Download .hic file
Hic.url <- paste0(
    "https://4dn-open-data-public.s3.amazonaws.com/",
    "fourfront-webprod/wfoutput/",
    "7386f953-8da9-47b0-acb2-931cba810544/4DNFIOTPSS3L.hic"
)
HicOutput.pth <- file.path(temp.dir, "Control_HIC.hic")
HicOutput.pth <- normalizePath(HicOutput.pth)
if(.Platform$OS.type == "windows"){
    download.file(Hic.url, HicOutput.pth, method = "auto",
    extra = "-k",mode="wb")
}else{
    download.file(Hic.url, HicOutput.pth, method = "auto", extra = "-k")
}

# Import .hic file
HiC_Ctrl.cmx_lst <- ImportHiC(
    file = HicOutput.pth,
    hicResolution = 100000,
    chrom_1 = c("2L", "2L", "2R"),
    chrom_2 = c("2L", "2R", "2R")
)

# Download .mcool file
Mcool.url <- paste0(
    "https://4dn-open-data-public.s3.amazonaws.com/",
    "fourfront-webprod/wfoutput/",
    "4f1479a2-4226-4163-ba99-837f2c8f4ac0/4DNFI8DRD739.mcool"
)
McoolOutput.pth <- file.path(temp.dir, "HeatShock_HIC.mcool")
HicOutput.pth <- normalizePath(McoolOutput.pth)
if(.Platform$OS.type == "windows"){
    download.file(Mcool.url, McoolOutput.pth, method = "auto",
    extra = "-k",mode="wb")
}else{
    download.file(Mcool.url, McoolOutput.pth, method = "auto",
    extra = "-k")
}

# Import .mcool file
HiC_HS.cmx_lst <- ImportHiC(
    file = McoolOutput.pth,
    hicResolution = 100000,
    chrom_1 = c("2L", "2L", "2R"),
    chrom_2 = c("2L", "2R", "2R")
)
}
# Import .h5 file
h5_path <- system.file("extdata",
    "Control_HIC_10k_2L.h5",
    package = "HicAggR", mustWork = TRUE
)
binSize=10000
hicLst <- ImportHiC(
  file      = h5_path,
  hicResolution       = binSize,
  chromSizes = data.frame(seqnames = c("2L"), 
  seqlengths = c(23513712)),
  chrom_1   = c("2L")
)
}
