% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_plot.R
\name{pmMultiBarplot}
\alias{pmMultiBarplot}
\title{Plot both mutation signatures and their mutational exposures from
pmsignature output for more than two groups}
\usage{
pmMultiBarplot(
  inputG,
  inputParam,
  sigOrder = NULL,
  groupIndices,
  sortSampleNum = TRUE,
  charSize = 3
)
}
\arguments{
\item{inputG}{a MutationFeatureData S4 class output by the pmsignature.}

\item{inputParam}{a estimatedParameters S4 class output by the pmsignature.}

\item{sigOrder}{the order of signatures if needed (default: NULL).}

\item{groupIndices}{a vector of group indicators.}

\item{sortSampleNum}{an indictor variable on whether samples are sorted by
the number of mutations (default: TRUE).}

\item{charSize}{the size of the character on the signature plot (default: 3)}
}
\value{
a list of the signature plot and the mean difference plot.
}
\description{
Plot both mutation signatures and their mutational exposures from
pmsignature output for more than two groups
}
\examples{

load(system.file("extdata/sample.rdata", package="HiLDA"))
Param <- pmgetSignature(G, K = 3)

pmPlots <- pmMultiBarplot(G, Param, groupIndices=c(1, rep(2,3), rep(3,6)))
cowplot::plot_grid(pmPlots$sigPlot, pmPlots$propPlot, rel_widths = c(1,3))

}
