% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilda_plot.R
\name{hildaDiffPlot}
\alias{hildaDiffPlot}
\title{Read the raw mutation data with the mutation feature vector format,
  estimate and plot both mutation signatures and their fractions}
\usage{
hildaDiffPlot(inputG, hildaResult, sigOrder = NULL, charSize = 3)
}
\arguments{
\item{inputG}{a MutationFeatureData S4 class output by the pmsignature.}

\item{hildaResult}{a rjags class output by HiLDA.}

\item{sigOrder}{the order of signatures if needed (default: NULL).}

\item{charSize}{the size of the character on the signature plot (default: 3)}
}
\value{
a list of the signature plot and the mean difference plot.
}
\description{
Read the raw mutation data with the mutation feature vector format,
  estimate and plot both mutation signatures and their fractions
}
\examples{

load(system.file("extdata/sample.rdata", package="HiLDA"))
inputFile <- system.file("extdata/hildaLocal.rdata", package="HiLDA")
hildaLocal <- readRDS(inputFile)

hildaDiffPlot(G, hildaLocal)

}
