% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotPs}
\alias{plotPs}
\alias{plotPsSlope}
\title{Plotting a P(s) distance law}
\usage{
plotPs(x, mapping, xlim = c(5000, 499000), ylim = c(1e-08, 1e-04))

plotPsSlope(x, mapping, xlim = c(5000, 499000), ylim = c(-3, 0))
}
\arguments{
\item{x}{the output data.frame of \code{distanceLaw} function}

\item{mapping}{aes to pass on to ggplot2}

\item{xlim}{xlim}

\item{ylim}{ylim}
}
\value{
ggplot
}
\description{
Plotting a P(s) distance law
}
\examples{
## Single P(s)

contacts_yeast <- contacts_yeast()
ps <- distanceLaw(contacts_yeast)
plotPs(ps, ggplot2::aes(x = binned_distance, y = norm_p))

## Comparing several P(s)

contacts_yeast <- contacts_yeast()
contacts_yeast_eco1 <- contacts_yeast_eco1()
ps_wt <- distanceLaw(contacts_yeast)
ps_wt$sample <- 'WT'
ps_eco1 <- distanceLaw(contacts_yeast_eco1)
ps_eco1$sample <- 'eco1'
ps <- rbind(ps_wt, ps_eco1)
plotPs(ps, ggplot2::aes(x = binned_distance, y = norm_p, group = sample, color = sample))
plotPsSlope(ps, ggplot2::aes(x = binned_distance, y = slope, group = sample))
}
