% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_interactions.R
\name{export_interactions}
\alias{export_interactions}
\title{Export interactions in the desired output format}
\usage{
export_interactions(
  interactions,
  file,
  format = "ibed",
  over.write = FALSE,
  cutoff = 5,
  parameters = FALSE
)
}
\arguments{
\item{interactions}{GenomicInteractions object from \code{\link{load_interactions}}}

\item{file}{full path to desired output file (ibed, peakmatrix, washU, washUold, cytoscape, bedpe)}

\item{format}{type of output format (ibed, peakmatrix, washU, washUold, cytoscape, bedpe, seqmonk)}

\item{over.write}{TRUE/FALSE to over write the output file}

\item{cutoff}{Chicago score cutoff to export interactions}

\item{parameters}{TRUE/FALSE to also export the parameters of the given object}
}
\value{
tibble object with the ibed table and save it in the desired output file
}
\description{
This function exports interactions in different formats
}
\examples{

ibed1 <- system.file("extdata", "ibed1_example.zip", package = "HiCaptuRe")
interactions <- load_interactions(ibed1, select_chr = "19")
export_interactions(interactions = interactions, file = tempfile(), format = "ibed", over.write = TRUE)

}
