% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digest_genome.R
\name{digest_genome}
\alias{digest_genome}
\title{Digest genome for a specific restriction enzyme}
\usage{
digest_genome(
  genome = "GRCh38",
  RE_name = "HindIII",
  motif = NULL,
  cut_position = NULL,
  select_chr = c(seq_len(22), "X", "Y"),
  PAR_mask = TRUE,
  PAR_file = NULL,
  ...
)
}
\arguments{
\item{genome}{character with the name of the genome version}

\item{RE_name}{name of the restriction enzyme}

\item{motif}{recognition motif of the restriction enzyme}

\item{cut_position}{cut position of the restriction enzyme inside the motif}

\item{select_chr}{a character vector containing the specific chromosomes to used from this genome, if NULL all chromosomes will be used}

\item{PAR_mask}{a logical value where the Y chromosome should exclude the Pseudoautosomical Regions (PAR) or not}

\item{PAR_file}{a full path to a file containing the coordinates of Y chromosome PAR with at least 3 columns with header: seqnames, start, end}

\item{...}{extra arguments for read.table}
}
\value{
list object with 2 elements: a dataframe with the digested genome, and a the parameters used for the digestion.
}
\description{
This function takes a genome installed and generates its digest for a given restriction enzyme
}
\note{
The package provides for a PAR coordinates file only for Homo sapiens for the genome version 38

The package provides the motives and cut positions for several restriction enzymes (HindIII, MboI, DpnII, EcoRI, BamHI)
}
\examples{

digest <- digest_genome(genome = "GRCh38", RE_name = "HindIII", select_chr = "19")

}
