% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{mergeInteractionSet}
\alias{mergeInteractionSet}
\title{Merge two InteractionSet objects}
\usage{
mergeInteractionSet(interactionSet1, interactionSet2, fill = NA)
}
\arguments{
\item{interactionSet1}{The first \code{\link{InteractionSet}}.}

\item{interactionSet2}{The second \code{\link{InteractionSet}}.}

\item{fill}{Fill missing values with this.}
}
\value{
The merged \code{\link{InteractionSet}}.
}
\description{
Merge two different \code{\link{InteractionSet}}.
}
\examples{
path <- system.file("extdata", "hicsample_21.cool", package = "HiCParser")
object1 <- parseCool(path, conditions = 1, replicates = 1)
# Creating an object with a different condition
object2 <- parseCool(path, conditions = 2, replicates = 1)
objectMerged <- mergeInteractionSet(object1, object2)

}
