% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-hic.R
\name{parse-hic}
\alias{parse-hic}
\alias{.hic2gi}
\alias{.lsHicResolutions}
\alias{.getHicAnchors}
\alias{.hic2seqinfo}
\alias{.dumpHic}
\title{Parsing hic files}
\usage{
.hic2gi(file, coords = NULL, resolution = NULL)

.lsHicResolutions(file, verbose = FALSE)

.getHicAnchors(file, resolution = NULL)

.hic2seqinfo(file)

.dumpHic(file, resolution = NULL)
}
\arguments{
\item{file}{path to a Hi-C contact file in .hic format}

\item{coords}{NULL, character, or GRanges.
Can also be a Pairs object of paired GRanges (length of 1).}

\item{resolution}{resolution of the contact matrix to use}

\item{verbose}{Print resolutions in the console}
}
\value{
a GInteractions object

vector
}
\description{
These functions are the workhorse internal functions used to import
a \code{.hic} file as GInteractions (wrapped into a \code{HiCExperiment} object
by \code{HiCExperiment()} function).
}
\keyword{internal}
