% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContactsFile-class.R, R/ContactsFile-methods.R
\docType{class}
\name{ContactsFile-class}
\alias{ContactsFile-class}
\alias{ContactsFile}
\alias{ContactsFile-methods}
\alias{pairsFile,ContactsFile-method}
\alias{resolution,ContactsFile-method}
\alias{metadata<-,ContactsFile-method}
\alias{metadata<-,ContactsFile,list-method}
\title{\code{ContactsFile} S4 class}
\arguments{
\item{path}{String; path to an Hi-C matrix file (cool, mcool, hic, hicpro)}

\item{resolution}{numeric; resolution to use with Hi-C matrix file}

\item{pairsFile}{String; path to a pairs file}

\item{metadata}{list.}

\item{object}{A \code{ContactsFile} object.}

\item{x}{A \code{ContactsFile} object.}
}
\description{
The \code{ContactsFile} class describes a \code{BiocFile} object, pointing to the location
of an Hi-C matrix file (cool, mcool, hic, hicpro, ...) and containing additional slots:
\enumerate{
\item resolution: at which resolution the associated mcool file should be parsed
\item pairsFile: the path (in plain character) to an optional pairs file
(stored as a \code{PairsFile} object);
\item metadata: a list. If the CoolFile is created by \code{HiCool}, it will contain
two elements: \code{log} (path to \code{HiCool} processing log file) and \code{stats}
(aggregating some stats from \code{HiCool} mapping).
}

ContactsFile methods.
}
\section{Slots}{

\describe{
\item{\code{resolution}}{numeric value or NULL}

\item{\code{pairsFile}}{PairsFile object}

\item{\code{metadata}}{list}
}}

\seealso{
\code{\link[=CoolFile]{CoolFile()}}, \code{\link[=HicFile]{HicFile()}}, \code{\link[=HicproFile]{HicproFile()}}
}
