#' @title `PairsFile` S4 class
#' 
#' @name PairsFile-class
#' @aliases PairsFile
#' 
#' @description
#' 
#' The `PairsFile` class describes a `BiocFile` object, pointing to the location 
#' of pairs file, typically generated by `HiCool::HiCool()`. 
#'
#' @param x Path to a pairs file
#' 
#' @importFrom methods setClass
#' @importFrom S4Vectors isSingleString
#' @importClassesFrom BiocIO BiocFile
#' @seealso [CoolFile()], [HicFile()], [HicproFile()]
#' @examples 
#' pairsPath <- HiContactsData::HiContactsData('yeast_wt', 'pairs.gz')
#' pf <- PairsFile(pairsPath)
#' pf
#' pairsFile(pf)
NULL

#' @export

setClass('PairsFile', contains = 'BiocFile')

setClassUnion("PairsFileOrNULL", members = c("PairsFile", "NULL"))

#' @export

PairsFile <- function(x) {
    if (is.null(x)) 
        return(NULL)
    new('PairsFile', resource = x)
}
