% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gi_list2HTClist.R
\name{gi_list2HTClist}
\alias{gi_list2HTClist}
\title{gi_list2HTClist}
\usage{
gi_list2HTClist(gi_list, chrs = NULL)
}
\arguments{
\item{gi_list}{List of \code{GenomicInteractions} objects with a counts
column where each object
named with chromosomes contains intra-chromosomal interaction information
(minimally containing counts and genomic distance in \code{mcols(gi_list)}---
see \code{?gi_list_validate} for a detailed explanation of valid
\code{gi_list} instances).}

\item{chrs}{select a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to chromosomes in \code{gi_list}.}
}
\value{
a HTClist instance compatible for use with HiTC
}
\description{
This function converts a gi_list instance into a HTClist instance
compatible for use with the R Bioconductor package HiTC
https://bioconductor.org/packages/HiTC/
}
\examples{
gi_list<-generate_binned_gi_list(50e3,chrs=c('chr22'))
gi_list<-add_hic_counts(gi_list,
hic_path<-system.file("extdata", "GSE63525_HMEC_combined_example.hic",
package = "HiCDCPlus"))
htc_list<-gi_list2HTClist(gi_list)
}
