% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Brick_functions.R
\name{Brick_get_matrix_within_coords}
\alias{Brick_get_matrix_within_coords}
\title{Return a matrix subset between two regions.}
\usage{
Brick_get_matrix_within_coords(
    Brick,
    x_coords,
    y_coords,
    resolution,
    force = FALSE,
    FUN = NULL
)
}
\arguments{
\item{Brick}{\strong{Required}.
A string specifying the path to the Brick store created with
Create_many_Brick.}

\item{x_coords}{\strong{Required}.
A string specifying the region to subset on the rows. It takes the form
chr:start:end. An overlap operation with the associated bintable will be
done to identify the bins to subset on the row}

\item{y_coords}{\strong{Required}.
A string specifying the region to subset on the rows. It takes the form
chr:start:end. An overlap operation with the associated bintable will be
done to identify the bins to subset on the column}

\item{resolution}{\strong{Optional}. Default NA
When an object of class BrickContainer is provided, resolution defines the
resolution on which the function is executed}

\item{force}{\strong{Optional}. Default FALSE
If true, will force the retrieval operation when matrix contains loaded
data until a certain distance.}

\item{FUN}{\strong{Optional}.
If provided a data transformation with FUN will be applied before
the matrix is returned.}
}
\value{
Returns a matrix of dimension x_coords binned length by y_coords
binned length. This may differ based on FUN.
}
\description{
\code{Brick_get_matrix_within_coords} will fetch a matrix subset after
creating an overlap operation between both regions and the bintable
associated to the Brick store.
This function calls \code{\link{Brick_get_matrix}}.
}
\examples{

Bintable.path <- system.file(file.path("extdata", "Bintable_100kb.bins"), 
package = "HiCBricks")

out_dir <- file.path(tempdir(), "get_matrix_coords_test")
dir.create(out_dir)

My_BrickContainer <- Create_many_Bricks(BinTable = Bintable.path, 
    bin_delim = " ", output_directory = out_dir, file_prefix = "Test",
    experiment_name = "Vignette Test", resolution = 100000,
    remove_existing = TRUE)

Matrix_file <- system.file(file.path("extdata", 
"Sexton2012_yaffetanay_CisTrans_100000_corrected_chr2L.txt.gz"), 
package = "HiCBricks")

Brick_load_matrix(Brick = My_BrickContainer, chr1 = "chr2L", 
chr2 = "chr2L", matrix_file = Matrix_file, delim = " ", 
remove_prior = TRUE, resolution = 100000)

Brick_get_matrix_within_coords(Brick = My_BrickContainer,
x_coords = "chr2L:1:1000000",
y_coords = "chr2L:1:1000000",
resolution = 100000)

Brick_get_matrix_within_coords(Brick = My_BrickContainer,
x_coords = "chr2L:1:1000000",
y_coords = "chr2L:1:1000000",
resolution = 100000,
FUN = mean)


}
\seealso{
\code{\link{Brick_get_matrix}} to get matrix by using matrix
coordinates, \code{\link{Brick_get_values_by_distance}} to get values
separated at a certain distance, \code{\link{Brick_fetch_row_vector}}
to get values in a certain row/col and subset them,
\code{\link{Brick_get_vector_values}} to get values using matrix
coordinates.
}
