% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulateMicroarray}
\alias{simulateMicroarray}
\title{Simulate log-transformed microarray gene expression data}
\usage{
simulateMicroarray(
  crosstab,
  m,
  delta = 1,
  gamma = 0.5,
  phi = 0.2,
  c = 10,
  d = 6,
  epsilon = 0.5,
  kappa = 0.2,
  a = 40,
  b = 5,
  dropout = FALSE,
  r = 2,
  s = -6
)
}
\arguments{
\item{crosstab}{matrix of contingency table specifying number of samples in
each class-batch condition, with classes as rows and batches as columns.}

\item{m}{number of genes.}

\item{delta}{magnitude of additive batch effects (i.e. standard deviation
of normal distribution modelling batch log fold change means of all genes).}

\item{gamma}{magnitude of multiplicative batch effects (i.e. standard
deviation of normal distribution modelling log batch effect terms of all
samples in a batch).}

\item{phi}{percentage of differentially expressed genes.}

\item{c}{shape parameter of Gamma distribution modelling class log fold
change means of all genes.}

\item{d}{rate parameter of Gamma distribution modelling class log fold
change means of all genes.}

\item{epsilon}{magnitude of random noise across samples (i.e. standard
deviation of normal distribution modelling log expression values with
class effects only).}

\item{kappa}{standard deviation of normal distribution modelling log scaling
factors of all samples.}

\item{a}{shape parameter of Gamma distribution modelling basal log mean
expression of all genes.}

\item{b}{rate parameter of Gamma distribution modelling basal log mean
expression of all genes.}

\item{dropout}{logical indicating whether to perform dropout}

\item{r}{inverse scale parameter of the sigmoid function used to calculate
probability of dropout for each value.}

\item{s}{midpoint parameter of the sigmoid function used to calculate
probability of dropout for each value.}
}
\value{
A list containing the following components:
  \describe{
    \item{`X`}{matrix with dimensions `(m, n)` of log expression values.}
    \item{`metadata`}{data frame with `n` rows of sample metadata.}
    \item{`diff.genes`}{
      character vector, names of differentially expressed genes.}
    \item{`Y`}{
      matrix with dimensions `(m, n)` of log expression values with class
      effects only.}
    \item{`batch.terms`}{
      matrix with dimensions `(m, n)` of log batch effect terms.}
    \item{`class.logfc`}{
      matrix of class log fold change means for each gene in each class}
    \item{`batch.logfc`}{
      matrix of batch log fold change means for each gene in each batch.}
    \item{`params`}{list of parameters supplied.}
  }
}
\description{
Simulate log-transformed microarray gene expression data
}
\examples{

crosstab <- matrix(10, 3, 2)
data <- simulateMicroarray(crosstab, 100)

}
\author{
Wei Xin Chan
}
