% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HVP.R
\name{HVP}
\alias{HVP}
\alias{HVP,matrix-method}
\alias{HVP,Matrix-method}
\alias{HVP,data.frame-method}
\alias{HVP,Seurat-method}
\alias{HVP,SummarizedExperiment-method}
\title{Hierarchical variance partitioning (HVP)}
\usage{
HVP(x, ...)

\S4method{HVP}{matrix}(x, batch, cls = NULL, nperm = 0, use.sparse = FALSE, ...)

\S4method{HVP}{Matrix}(x, batch, cls = NULL, nperm = 0, use.sparse = FALSE, ...)

\S4method{HVP}{data.frame}(x, ...)

\S4method{HVP}{Seurat}(x, batchname, classname = NULL, nperm = 0, use.sparse = FALSE, ...)

\S4method{HVP}{SummarizedExperiment}(
  x,
  batchname,
  classname = NULL,
  assayname = NULL,
  nperm = 0,
  use.sparse = FALSE,
  ...
)
}
\arguments{
\item{x}{object to calculate HVP for.}

\item{...}{additional arguments to pass to S4 methods.}

\item{batch}{vector, indicating the batch information of samples.}

\item{cls}{vector or list of vectors with class information of samples.}

\item{nperm}{numeric indicating number of permutations to simulate in the
Monte Carlo permutation test. We recommend a value no less than 1000.
By default, no permutation test is performed.}

\item{use.sparse}{logical indicating whether to use sparse matrices when
 computing HVP. N.B. Using sparse matrices may lead to slight increase
in run time.}

\item{batchname}{character, name of column in metadata indicating batch.}

\item{classname}{character, name of column/s in metadata indicating class.}

\item{assayname}{character, name of assay to use. By default the first
assay is used.}
}
\value{
hvp S4 object with the following slots:
  \describe{
    \item{`HVP`}{the proportion of variance associated with batch effects.}
    \item{`sum.squares`}{matrix of sum of squares between batch and total
      sum of squares for all features.}
    \item{`p.value`}{p-value of permutation test}
    \item{`null.distribution`}{numeric, null distribution of HVP values.}
  }
  Last two components are only present if permuation test is performed.
}
\description{
`HVP` calculates the proportion of variance associated with batch effects
in a data set (the "HVP" value of a data set). To determine whether batch
effects are statistically significant in a data set, a permutation test can
be performed by setting `nperm` to a number above 100. `HVP` is
an S4 generic function; methods can be added for new classes. S4 methods
for class: array-like objects, `SummarizedExperiment`, 
`SingleCellExperiment` and `Seurat` are provided.
}
\details{
S4 method for class data frame or matrix takes in array with
  dimensions (nfeatures, nsamples).

S4 method for `SummarizedExperiment` is applicable for the
  `SingleExperiment` class as well, as it inherits from the
  `SummarizedExperiment` class.
}
\examples{

X <- matrix(rnorm(1000), 50, 20)
batch <- factor(rep(1:2, each = 10))
class <- factor(rep(LETTERS[1:2], 10))

res <- HVP(X, batch, class)

}
\author{
Wei Xin Chan
}
