% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hippo.R
\name{hippo_feature_heatmap}
\alias{hippo_feature_heatmap}
\title{HIPPO's feature heatmap}
\usage{
hippo_feature_heatmap(
  sce,
  switch_to_hgnc = FALSE,
  ref = NA,
  top.n = 50,
  kk = 2,
  plottitle = ""
)
}
\arguments{
\item{sce}{SingleCellExperiment object with hippo}

\item{switch_to_hgnc}{if the current gene names are ensemble ids, and would
like to switch to hgnc}

\item{ref}{a data frame with columns 'hgnc' and 'ensg' to match each other,
only required when switch_to_hgnc is set to TRUE}

\item{top.n}{number of markers to return}

\item{kk}{integer for the round of clustering that you'd like to see result.
Default is 2}

\item{plottitle}{title for the plot}
}
\value{
list of differential expression result
}
\description{
HIPPO's feature heatmap
}
\examples{
data(toydata)
set.seed(20200321)
toydata = hippo(toydata,K = 10,z_threshold = 1,outlier_proportion = 0.01)
hippo_feature_heatmap(toydata)
}
