% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcProbePvaluesT.R
\name{calcProbePValuesTUnpaired}
\alias{calcProbePValuesTUnpaired}
\title{Calculate Probe p-values using a differential unpaired t-test}
\usage{
calcProbePValuesTUnpaired(probe_mat, colData_in, sd_shift = NA, abs_shift = NA)
}
\arguments{
\item{probe_mat}{numeric matrix or data.frame of values}

\item{colData_in}{design data.frame}

\item{sd_shift}{standard deviation shift to use when calculating p-values
Either sd_shift or abs_shift should be set}

\item{abs_shift}{absolute shift to use when calculating p-values}
}
\value{
matrix of p-values on the post columns defined in the colData matrix
}
\description{
Calculate Probe p-values using a differential unpaired t-test
}
\examples{
data(heffron2021_wuhan)
colData_wu <- colData(heffron2021_wuhan)
pval_res <- calcProbePValuesTUnpaired(assay(heffron2021_wuhan), colData_wu)
}
