% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMDS.R
\name{plotMDS}
\alias{plotMDS}
\title{Plot the multidimensional scaling of the GloScope represenation}
\usage{
plotMDS(dist_mat, metadata_df, sample_id, k = 10, color_by, shape_by)
}
\arguments{
\item{dist_mat}{The divergence matrix output of `gloscope()`. Should be a
symmetric, square matrix.}

\item{metadata_df}{A data frame contains each sample's metadata. Note this is
NOT at the cell-level, and should have the same number of rows as dist_mat.}

\item{sample_id}{The column name or index in metadata_df that contains the
sample ID. This is for ensuring alignment between the dist_mat and the
metadata_df. The rownames of dist_mat are expected to match the sample_id
values.}

\item{k}{Number of MDS dimension to generate, default = 10}

\item{color_by}{The column name or index in metadata_df that should be used
to color the points by. If missing all points will be the same color.}

\item{shape_by}{The column name or index in metadata_df that should be used
to determine the shape of the points. If missing all points will be the
same shape.}
}
\value{
A list containing the MDS embedding and plot of the distance matrix
\itemize{
  \item mds - A data.frame containing the MDS embedding, with the number of rows equal to the number of samples.
  \item plot - A ggplot object containing the plot object. `print` of the object will create a plot.
}
}
\description{
This function calculates the multidimensional scaling for a
  GloScope divergence matrix and returns a ggplot object that plots it.
}
\details{
The function calls \code{\link[MASS]{isoMDS}} from the MASS package,
  calculates the requested k coordinates of the MDS plot. It also creates a
  ggplot object that will plot the first two dimensions color or shape coded
  by the given variables in the metadata data frame.
}
\examples{
data(example_SCE_small)
sample_ids <- SingleCellExperiment::colData(example_SCE_small)$sample_id
# Run gloscope on first 10 PCA embeddings
# We use 'KNN' option for speed ('GMM' is slightly slower)
pca_embeddings <- SingleCellExperiment::reducedDim(example_SCE_small,"PCA")
pca_embeddings_subset <- pca_embeddings[,seq_len(10)] # select the first 10 PCs
dist_result <- gloscope(pca_embeddings_subset, sample_ids,
   dens="KNN",
   BPPARAM = BiocParallel::SerialParam(RNGseed=2))
# make a per-sample metadata
sample_metadata <- as.data.frame(unique(SingleCellExperiment::colData(example_SCE_small)[,c(1,2)]))
mds_result <- plotMDS(dist_mat = dist_result, metadata_df = sample_metadata ,
sample_id="sample_id", color_by="phenotype",k=2)
head(mds_result$mds)
require(ggplot2)
mds_result$plot
# Add additional ggplot2 components to adapt figure
mds_result$plot + theme_bw()  + scale_color_manual(values=alpha(c("red","blue"),0.5))
}
\seealso{
\code{\link[MASS]{isoMDS}}
}
