% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimmaXY.R
\name{buildXYData}
\alias{buildXYData}
\title{XY Data Object Builder}
\usage{
buildXYData(
  table,
  status,
  main,
  display.columns,
  anno,
  counts,
  xlab,
  ylab,
  status.cols,
  sample.cols,
  groups,
  transform.counts
)
}
\arguments{
\item{table}{dataframe containing xlab and ylab columns for plotting.}

\item{status}{vector of length \code{nrow(x)} indicating the status of each gene.
By default genes in the summary plot are coloured based on its differential expression status
using an adjusted p-value cutoff of 5\% by calling the \code{limma::decideTests} function, where
the value of -1 marks down-regulated genes, 0 marks genes with no expression difference, and
1 marks up-regulated genes.}

\item{main}{character string for the main title of summary plot.}

\item{display.columns}{character vector containing names of columns from \code{anno} from
which to display in mouseover tooltips and table.}

\item{anno}{dataframe with \code{nrow(x)} rows containing gene annotations.}

\item{counts}{numeric matrix with \code{nrow(x)} rows containing gene expression values.
This can be used to replace the gene counts from \code{dge$counts}, i.e. you may have
log-rpkm values stored in a different object that you wish to use.}

\item{xlab}{character string for the x-axis label of summary plot.}

\item{ylab}{character string for the y-axis label of summary plot.}

\item{status.cols}{vector of length 3 containing valid CSS strings for colours associated
with \code{status}  in the order of -1, 0 and 1.}

\item{sample.cols}{character vector of length \code{ncol(counts)} containing valid CSS strings
for colours associated with each sample to be displayed on the expression plot. If left
unspecified, samples will be coloured according to \code{groups}.}

\item{groups}{vector of length \code{ncol(dge)} representing categorisation of samples in
expression plot.}

\item{transform.counts}{the type of transformation used on the counts - "logcpm" for using \code{edgeR::cpm(counts, log=TRUE)};
"cpm" for \code{edgeR::cpm(counts)}; "rpkm" for \code{edgeR::rpkm(counts)}; "logrpkm" for \code{edgeR::rpkm(counts, log=TRUE)}; and "none" for no transformation). Defaults to "logcpm".}
}
\value{
object for XY plot internal use
}
\description{
Common processing steps for both MA, XY and volcano plots.
Expects a dataframe, \code{table}, which contains two columns labelled \code{xlab} and \code{ylab}
as well as a unique identifier column labelled \code{gene}.
}
\keyword{internal}
