% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxSetWllq.R
\name{gtoxSetWllq}
\alias{gtoxSetWllq}
\title{Change the well quality for a vector of lvl 0 IDs}
\usage{
gtoxSetWllq(ids, wllq, type)
}
\arguments{
\item{ids}{Integer, the 'm0id' or 's0id' values to change}

\item{wllq}{Integer of length 1, the new well quality value, 0 or 1}

\item{type}{Character of length 1, the data type, "sc" or "mc"}
}
\value{
TRUE if successful.
}
\description{
\code{gtoxSetWllq} changes the well quality to either 100 or 0 for a given
list of 'm0id' or 's0id' values. Changing the well quality initiates a
delete cascade for the affected assay components.
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Set well quality to zero for specific lvl zero ids.
gtoxSetWllq(ids = 1633, wllq = 0, type = "mc")

## Reset configuration
options(conf_store)

}
