% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtoxPrepOtpt.R
\name{gtoxPrepOtpt}
\alias{gtoxPrepOtpt}
\title{Map assay/chemcial ID values to annotation information}
\usage{
gtoxPrepOtpt(dat, ids = NULL)
}
\arguments{
\item{dat}{data.table, output from \code{\link{gtoxLoadData}}}

\item{ids}{Character, (optional) a subset of ID fields to map}
}
\value{
The given data.table with chemical and assay information mapped
}
\description{
\code{gtoxPrepOtpt} queries the chemical and assay information from the gtox
database, and maps the annotation information to the given data.
}
\details{
\code{gtoxPrepOtpt} is used to map chemical and assay identifiers to their
respective names and annotation information to create a human-readable table
that is more suitable for an export/output.

By default the function will map sample ID (spid), assay component id (acid),
and assay endpoint ID (aeid) values. However, if 'ids' is not null, the
function will only attempt to map the ID fields given by 'ids.'
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- gtoxConfList()
gtoxConfDefault()

## Load some example data
d1 <- gtoxLoadData(1)

## Check for chemical name in 'dat'
"chnm" \%in\% names(d1) ## FALSE

## Map chemical annotation only
d2 <- gtoxPrepOtpt(d1, ids = "spid")
"chnm" \%in\% names(d2) ## TRUE
"acnm" \%in\% names(d2) ## FALSE

## Map all annotations
d3 <- gtoxPrepOtpt(d1) ## Also works if function is given d2
"chnm" \%in\% names(d2) ## TRUE
"acnm" \%in\% names(d2) ## FALSE

## Reset configuration
options(conf_store)

}
