% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-normalize.R
\name{computeNormalizationFactors}
\alias{computeNormalizationFactors}
\title{Generate normalization factors}
\usage{
computeNormalizationFactors(
  object,
  igg.names = NULL,
  hk.names = NULL,
  area = NULL,
  nuclei = NULL
)
}
\arguments{
\item{object}{name of the object class to subset
\enumerate{
    \item{NanoStringGeoMxSet, use the NanoStringGeoMxSet class}
}}

\item{igg.names}{names of IgGs, if NULL IgGs will be detected automatically}

\item{hk.names}{names of HK, if NULL HK will be detected automatically}

\item{area}{name of area column in annotation sheet, optional}

\item{nuclei}{name of nuclei column in annotation sheet, optional}
}
\description{
For use with protein data ONLY.

Generate normalization factors for protein data to determine the best normalization method
}
\examples{
proteinData <- readRDS(file= system.file("extdata","DSP_Proteogenomics_Example_Data", 
"proteinData.rds", package = "GeomxTools"))

normfactors <- computeNormalizationFactors(object = proteinData)

normfactors_withAreaNuclei <- computeNormalizationFactors(object = proteinData,
area = "AOI.Size.um2", nuclei = "Nuclei.Counts")

}
