% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetEnrichedPathways.R
\name{subsetEnrichedPathways}
\alias{subsetEnrichedPathways}
\title{Subset enriched pathways of RAV}
\usage{
subsetEnrichedPathways(
  RAVmodel,
  ind = NULL,
  n = 10,
  both = FALSE,
  include_nes = FALSE
)
}
\arguments{
\item{RAVmodel}{PCAGenomicSignatures object. Also an output from
\code{\link[clusterProfiler]{GSEA}} can be used.}

\item{ind}{A numeric vector containing the RAV number you want to check
enriched pathways. If not specified, this function returns results from all
the RAVs.}

\item{n}{The number of top and bottom pathways to be selected based on
normalized enrichment score (NES).}

\item{both}{Default is \code{FALSE}, where only the top \code{n} pathways
will be printed. If it is set to \code{TRUE}, the output will contain both
top and bottom \code{n} pathways.}

\item{include_nes}{Defalt is \code{FALSE}. If it set to \code{TRUE}, the
output will include both description and NES of the enriched pathway.}
}
\value{
A DataFrame with top and bottom \code{n} pathways from the
enrichment results.
}
\description{
Subset enriched pathways of RAV
}
\examples{
data(miniRAVmodel)

# all RAVS in model
subsetEnrichedPathways(miniRAVmodel,n=5)

# only a specific RAV (note the colnames above)
subsetEnrichedPathways(miniRAVmodel,ind=695,n=5)


}
