% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleScoreHeatmap.R
\name{sampleScoreHeatmap}
\alias{sampleScoreHeatmap}
\title{Plot heatmap of the sample scores}
\usage{
sampleScoreHeatmap(
  score,
  dataName,
  modelName,
  cluster_rows = TRUE,
  cluster_columns = TRUE,
  show_row_names = TRUE,
  show_column_names = TRUE,
  row_names_gp = 0.7,
  column_names_gp = 5,
  ...
)
}
\arguments{
\item{score}{An output from \code{\link{calculateScore}} function, which is
a matrix with samples (row) and PrcompClusters (column) If it is a simple
vector, it will be converted to a one-column matrix.}

\item{dataName}{Title on the row. The name of the dataset to be scored.}

\item{modelName}{Title on the column. The RAVmodel used for scoring.}

\item{cluster_rows}{A logical. Under the default (\code{TRUE}), rows will be
clustered.}

\item{cluster_columns}{A logical. Under the default (\code{TRUE}), columns
will be clustered.}

\item{show_row_names}{Whether show row names. Default is \code{TRUE}, showing
the row name.}

\item{show_column_names}{Whether show column names. Default is \code{TRUE},
showing the column name.}

\item{row_names_gp}{Graphic parameters for row names. The default is 0.7.}

\item{column_names_gp}{Graphic parameters for column names. The default is 5.}

\item{...}{Any additional argument for \code{\link[ComplexHeatmap]{Heatmap}}}
}
\value{
A heatmap of the sample score. Rows represent samples and columns
represent RAVs.
}
\description{
Plot heatmap of the sample scores
}
\examples{
data(miniRAVmodel)
library(bcellViper)
data(bcellViper)
score <- calculateScore(dset, miniRAVmodel)
sampleScoreHeatmap(score, dataName="bcellViper", modelName="miniRAVmodel")

}
